<?php
/**
 * Meta Boxes
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Extend meta box "details" fields
 *
 * @param $fields
 * @return array
 */
function affcoups_pro_coupon_meta_box_details_fields( $fields ) {

    // Featured Coupon
    $fields[] = array(
        'name' => esc_html__( 'Featured', 'affiliate-coupons-pro' ),
        'id'   => AFFCOUPS_PREFIX . 'coupon_featured',
        'type' => 'checkbox',
        'desc' => esc_html__( 'Activate in order to show the coupon at the beginning of each list', 'affiliate-coupons-pro' ),
        'std'  => 0,
    );

    // Highlighted Coupon
    $fields[] = array(
        'name' => esc_html__( 'Highlighted', 'affiliate-coupons-pro' ),
        'id'   => AFFCOUPS_PREFIX . 'coupon_highlighted',
        'type' => 'checkbox',
        'desc' => esc_html__( 'Activate in order to highlight the coupon visually', 'affiliate-coupons-pro' ),
        'std'  => 0,
    );

    // Code reveal Coupon
    $fields[] = array(
        'name' => esc_html__( 'Disable click to reveal', 'affiliate-coupons-pro' ),
        'id'   => AFFCOUPS_PREFIX . 'click_to_reveal_disable',
        'type' => 'checkbox',
        'desc' => esc_html__( 'Activate in order to Disable click to reveal for this coupon', 'affiliate-coupons-pro' ),
        'std'  => 0,
    );
    // social share  option
    $fields[] = array(
        'name' => esc_html__( 'Disable social share  for this coupon', 'affiliate-coupons-pro' ),
        'id'   => AFFCOUPS_PREFIX . 'social_share_disable',
        'type' => 'checkbox',
        'desc' => esc_html__( 'Activate in order to Disable social share for this coupon', 'affiliate-coupons-pro' ),
        'std'  => 0,
    );

    return $fields;
}
add_filter( 'affcoups_coupon_meta_box_details_fields', 'affcoups_pro_coupon_meta_box_details_fields', 10 );
