<?php
/**
 * Scripts
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Load admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function affcoups_pro_admin_scripts() {

    wp_enqueue_script( 'affcoups-pro-admin', AFFCOUPS_PRO_PLUGIN_URL . 'assets/dist/js/admin.js', array( 'jquery' ), AFFCOUPS_PRO_VERSION );
    wp_enqueue_style( 'affcoups-pro-admin', AFFCOUPS_PRO_PLUGIN_URL . 'assets/dist/css/admin.css', false, AFFCOUPS_PRO_VERSION );
}
add_action( 'affcoups_enqueue_admin_scripts', 'affcoups_pro_admin_scripts' );

/**
 * Load frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function affcoups_pro_scripts() {

    wp_enqueue_script( 'affcoups-pro', AFFCOUPS_PRO_PLUGIN_URL . 'assets/dist/js/main.js', array( 'jquery' ), AFFCOUPS_PRO_VERSION, true );
    wp_enqueue_style( 'affcoups-pro', AFFCOUPS_PRO_PLUGIN_URL . 'assets/dist/css/main.css', false, AFFCOUPS_PRO_VERSION );

    // Register custom variables for AJAX script
    wp_localize_script( 'affcoups-pro', 'affcoupsPro', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' )
    ) );
}
add_action( 'affcoups_enqueue_scripts', 'affcoups_pro_scripts' );


/**
 * Load expiry countdown scripts
 *
 * @since       1.1.13
 * @return      void
 */
function affcoups_show_expiry_countdown() {

    ?>
<script>
var e=document.getElementsByClassName("expires-in");
    
    var z = setInterval(function() {
        for(let i=0;i<e.length;i++){        
    var x = new Date(e[i].title.slice(11)).getTime();
    var y = new Date().getTime();
    distance=x-y;
    if(distance>0){
    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((distance % (1000 * 60)) / 1000);
    var expire_counter=days+"d&nbsp;" + hours+"h&nbsp;"+  String(minutes).padStart(2, '0')+"m&nbsp;"+ String(seconds).padStart(2, '0')+"s";
        document.getElementsByClassName("expiressed-in")[i].innerHTML = expire_counter;
    }
}
},1000);
</script>
    <?php
}
add_action('wp_head', 'affcoups_show_expiry_countdown');