<?php
/**
 * Statistics Functions
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Record click in database
 *
 * @param $data
 * @return int
 */
function affcoups_pro_stats_record( $data ) {
    return Affiliate_Coupons_Pro()->stats_db->add( $data );
}

/**
 * Get views count for a specific coupon
 *
 * @param $coupon_id
 * @param $type
 * @return mixed
 */
function affcoups_pro_stats_get_count( $coupon_id, $type ) {
    return Affiliate_Coupons_Pro()->stats_db->count( $coupon_id, $type );
}

/**
 * Reset stats for a specific coupon
 *
 * @param $coupon_id
 */
function affcoups_pro_stats_reset_records( $coupon_id ) {
    Affiliate_Coupons_Pro()->stats_db->reset( $coupon_id );
}

/**
 * Get popular coupons out of stats
 *
 * @param array $args
 * @return mixed
 */
function affcoups_pro_stats_get_popular_coupons( $args = array() ) {
    return Affiliate_Coupons_Pro()->stats_db->get_popular_coupons( $args );
}

/**
 * Check whether stats are enabled or not
 *
 * @return bool
 */
function affcoups_pro_stats_disabled() {
    return ( '1' == affcoups_get_option( 'tracking_disabled' ) ) ? true : false;
}

/**
 * Get popular coupon ids
 *
 * @param array $args
 * @return array
 */
function affcoups_pro_get_popular_coupon_ids( $args = array() ) {

    $coupon_ids = array();

    $defaults = array(
        'number' => 10,
        'type' => 'click'
    );

    // Parse args
    $args = wp_parse_args( $args, $defaults );

    $popular_coupons = affcoups_pro_stats_get_popular_coupons( $args );

    //affcoups_debug( $popular_coupons );

    if ( is_array( $popular_coupons ) && sizeof( $popular_coupons ) > 0 ) {

        foreach ( $popular_coupons as $popular_coupon ) {

            if ( isset( $popular_coupon->coupon_id ) )
                $coupon_ids[] = $popular_coupon->coupon_id;
        }
    }

    return $coupon_ids;
}