<?php
/**
 * Output Coupon Search Bar markup
 */
function affcoups_pro_tpl_the_search_bar() {

    ?>
    <label for="affcoups_search_query"><?php _e( 'Search Coupons', 'affiliate-coupons-pro' ); ?>&hellip;</label>

    <input type="search" id="affcoups_search_query" name="affcoups_search_query" class="search-field" placeholder="<?php _e( 'Search in coupon title or description', 'affiliate-coupons-pro' ); ?>&hellip;" />
    <?php
}

/**
 * Output Coupon Types Filter markup
 */
function affcoups_pro_tpl_the_search_types( $coupons ) {

    $types = array();

    foreach ( $coupons as $coupon ) {

        $terms = get_the_terms( $coupon->id, AFFCOUPS_COUPON_TYPE_TAXONOMY );

        if ( ! $terms || is_wp_error( $terms ) ) {
            continue;
        }

        foreach ( $terms as $term ) {
            $types[] = $term->term_id;
        }
    }

    $type_list = affcoups_get_types_taxonomy();

    $types = array_intersect_key( $type_list, array_flip( $types ) );

    if ( empty( $types ) ) {
        return;
    }

    $types = array( '0' => __( 'Select...', 'affiliate-coupons-pro' ) ) + $types;
    ?>
    <!-- Types -->
    <div class="search-dropdown-container search-dropdown-container__type">

        <label for="affcoups_search_type"><?php _e( 'Type', 'affiliate-coupons-pro' ); ?>&hellip;</label>

        <select class="search-dropdown search-dropdown__type" id="affcoups_search_type" name="affcoups_search_type">
            <?php foreach ( $types as $key => $label ) { ?>
                <option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_attr( $label ); ?></option>
            <?php } ?>
        </select>

    </div>
    <?php
}

/**
 * Output Coupon Category Filter markup
 */
function affcoups_pro_tpl_the_search_category( $coupons ) {

    $categories = array();

    foreach ( $coupons as $coupon ) {

        $terms = get_the_terms( $coupon->id, AFFCOUPS_COUPON_CATEGORY_TAXONOMY );

        if ( ! $terms || is_wp_error( $terms ) ) {
            continue;
        }

        foreach ( $terms as $term ) {
            $categories[] = $term->term_id;
        }
    }

    $category_list = affcoups_get_category_taxonomy();

    $categories = array_intersect_key( $category_list, array_flip( $categories ) );

    if ( empty( $categories ) ) {
        return;
    }

    $categories = array( '0' => __( 'Select...', 'affiliate-coupons-pro' ) ) + $categories;
    ?>
    <!-- Categories -->
    <div class="search-dropdown-container search-dropdown-container__category">

        <label for="affcoups_search_category"><?php _e( 'Category', 'affiliate-coupons-pro' ); ?>&hellip;</label>

        <select class="search-dropdown search-dropdown__category" id="affcoups_search_category" name="affcoups_search_category">
            <?php foreach ( $categories as $key => $label ) { ?>
                <option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_attr( $label ); ?></option>
            <?php } ?>
        </select>

    </div>
    <?php
}

/**
 * Output Vendor Filter markup
 */
function affcoups_pro_tpl_the_search_vendor( $coupons ) {

    $vendors = array();

    foreach ( $coupons as $coupon ) {

        $vendor_id = get_post_meta( $coupon->id, AFFCOUPS_PREFIX . 'coupon_vendor', true );

        if ( ! $vendor_id ) {
            continue;
        }

        $vendors[] = $vendor_id;
    }

    $vendor_list = affcoups_get_vendors_list();

    $vendors = array_intersect_key( $vendor_list, array_flip( $vendors ) );

    if ( empty( $vendors ) ) {
        return;
    }
    if(0){
?>

<!-- Vendors -->
<div>

<label ><?php _e( 'Vendor', 'affiliate-coupons-pro' ); ?>&hellip;</label><br>
    <?php foreach ( $vendors as $key => $label ) { ?>
        <button type="button"><?php echo esc_attr( $label ); ?></button> 
    <?php } ?>

</div>


<?php
}else {
    $vendors = array( '0' => __( 'Select...', 'affiliate-coupons-pro' ) ) + $vendors;
    ?>
    <!-- Vendors -->
    <div class="search-dropdown-container search-dropdown-container__vendor">

        <label for="affcoups_search_vendor"><?php _e( 'Vendor', 'affiliate-coupons-pro' ); ?>&hellip;</label>

        <select class="search-dropdown search-dropdown__vendor" id="affcoups_search_vendor" name="affcoups_search_vendor">
            <?php foreach ( $vendors as $key => $label ) { ?>
                <option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_attr( $label ); ?></option>
            <?php } ?>
        </select>

    </div>
    <?php }
}

/**
 * Output 'Order By' and 'Order' Filters markup
 */
function affcoups_pro_tpl_the_search_ordering( $args ) {

    // Order By
    $orderby = ( ! empty( $args['affcoups_orderby'] ) ) ? $args['affcoups_orderby'] : 0;

    $ordersby = affcoups_get_orderby_options();

    $ordersby['0'] = __( 'Select...', 'affiliate-coupons-pro' );

    // Order
    $order = ( ! empty( $args['affcoups_order'] ) ) ? strtoupper( $args['affcoups_order'] ) : 'ASC';

    $orders = array(
        'ASC'  => __( 'ASC', 'affiliate-coupons' ),
        'DESC' => __( 'DESC', 'affiliate-coupons' ),
    );
    ?>
    <!-- Order By -->
    <div class="search-dropdown-container search-dropdown-container__orderby">

        <label for="affcoups_search_orderby"><?php _e( 'Order By', 'affiliate-coupons-pro' ); ?>&hellip;</label>

        <select class="search-dropdown search-dropdown__orderby" id="affcoups_search_orderby" name="affcoups_search_orderby">
            <?php foreach ( $ordersby as $key => $label ) { ?>
                <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $orderby, $key ); ?>><?php echo esc_attr( $label ); ?></option>
            <?php } ?>
        </select>

    </div>

    <!-- Order -->
    <div class="search-dropdown-container search-dropdown-container__order">

        <label for="affcoups_search_order"><?php _e( 'Order', 'affiliate-coupons-pro' ); ?>&hellip;</label>

        <select class="search-dropdown search-dropdown__order" id="affcoups_search_order" name="affcoups_search_order">
            <?php foreach ( $orders as $key => $label ) { ?>
                <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $order, $key ); ?>><?php echo esc_attr( $label ); ?></option>
            <?php } ?>
        </select>

    </div>
    <?php
}

/**
 * Output Coupon Search Form markup
 */
function affcoups_pro_tpl_the_search_filters( $args ) {

    $coupons = affcoups_get_coupons( $args );

    if ( empty( $coupons ) ) {
        return;
    }

    $show_filters = array();

    $options = affcoups_get_options();

    if ( empty( $options['hide_search_bar'] ) ) {
        $show_filters['bar'] = true;
    }

    if ( empty( $options['hide_search_types'] ) && empty( $args['affcoups_coupon_type'] ) ) {
        $show_filters['types'] = true;
    }

    if ( empty( $options['hide_search_category'] ) && empty( $args['affcoups_coupon_category'] ) ) {
        $show_filters['category'] = true;
    }

    if ( empty( $options['hide_search_vendor'] ) && empty( $args['affcoups_coupon_vendor'] ) ) {
        $show_filters['vendor'] = true;
    } ?>
    <div class="affcoups-coupon__search_filters">

        <form role="search" method="post" class="search-filters-form <?php if ( ! isset( $show_filters['bar'] ) ) { echo 'no-bar'; } ?>" action="">

            <input type="hidden" id="affcoups_search_args" name="affcoups_search_args" value="<?php echo base64_encode( serialize($args) ); ?>" />

            <?php if ( isset( $show_filters['bar'] ) ) : ?>

                <div class="affcoups-coupon__search_container searchbar">
                    <?php affcoups_pro_tpl_the_search_bar(); ?>

                    <input type="submit" class="search-submit affcoups-coupon__button" value="" />
                </div>

            <?php endif; ?>

            <div class="affcoups-coupon__search_container dropdowns">

                <?php if ( isset( $show_filters['types'] ) ) {
                    affcoups_pro_tpl_the_search_types( $coupons );
                } ?>

                <?php if ( isset( $show_filters['category'] ) ) {
                    affcoups_pro_tpl_the_search_category( $coupons );
                } ?>

                <?php if ( isset( $show_filters['vendor'] ) ) {
                    affcoups_pro_tpl_the_search_vendor( $coupons );
                } ?>

                <?php affcoups_pro_tpl_the_search_ordering( $args ); ?>

                <div class="reset">
                    <input type="reset" class="search-submit affcoups-coupon__button" value="<?php _e( 'Reset', 'affiliate-coupons-pro' ); ?>" />
                </div>
            </div>
        </form>
    </div>
    <?php
}

/**
 * Output "Load More" button markup
 */
function affcoups_pro_tpl_the_load_more_button( $atts ) {

    $options = affcoups_get_options();

    $button_text = ( ! empty( $options['pagination_button_text'] ) ) ? esc_html( $options['pagination_button_text'] ) : esc_html__( 'Load More', 'affiliate-coupons-pro' );
    $button_text = affcoups_cleanup_html_attribute( $button_text );
    ?>
    <div class="affcoups-load-more">
        <a href="#"
           id="affcoups-load-more"
           class="affcoups-coupon__button-load-more"
           data-paginated="<?php echo $atts['paginated']; ?>"
           data-args="<?php echo $atts['args']; ?>"
           <?php if ( isset( $atts['load_more_ids'] ) ) : ?>data-load-more-ids="<?php echo $atts['load_more_ids']; ?>"<?php endif; ?>
           title="<?php echo $button_text; ?>"><?php echo $button_text; ?></a>
    </div>
    <?php
}

