<?php
/**
 * Widget: Popular Coupons
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
};

if ( ! class_exists( 'Affcoups_Coupon_Popular_Widget' ) ) {

	/**
	 * Adds Affcoups_Coupon_Popular_Widget widget.
	 */
	class Affcoups_Coupon_Popular_Widget extends WP_Widget {

		protected static $did_script = false;

		/**
		 * Register widget with WordPress.
		 */
		function __construct() {
			parent::__construct(
				'affcoups_coupon_popular_widget', // Base ID
				__( 'Popular Coupons', 'affiliate-coupons-pro' ), // Name
				array( 'description' => __( 'Displays the most popular coupons.', 'affiliate-coupons-pro' ), ) // Args
			);
		}

		/**
		 * Front-end display of widget.
		 *
		 * @see WP_Widget::widget()
		 *
		 * @param array $args Widget arguments.
		 * @param array $instance Saved values from database.
		 */
		public function widget( $args, $instance ) {

			echo wp_kses_post( $args['before_widget'] );

			if ( ! empty( $instance['title'] ) ) {
				echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
			}

            $shortcode_atts = array();

            // IDs
            $coupon_ids = null;

            if ( ! empty ( $instance['orderby'] ) && ! empty ( $instance['max'] ) ) {

                $coupon_ids = affcoups_pro_get_popular_coupon_ids( array(
                    'type' => $instance['orderby'],
                    'number' => absint( $instance['max'] )
                ));
            }

            if ( $coupon_ids ) {

                $shortcode_atts['id'] = implode(',', $coupon_ids );
                $shortcode_atts['featured'] = 'false';
                $shortcode_atts['orderby'] = 'post__in';

                // Template
                $shortcode_atts['template'] = ( ! empty( $instance['template'] ) ) ? $instance['template'] : 'widget';

                // Style
                $shortcode_atts['style'] = ( ! empty( $instance['style'] ) ) ? $instance['style'] : 'standard';

                // Execute Shortcode
                affcoups_widget_do_shortcode( $shortcode_atts );

            } else {

                esc_html_e( 'No coupons found.', 'affiliate-coupons-pro' );
            }

			echo wp_kses_post( $args['after_widget'] );
		}

		/**
		 * Back-end widget form.
		 *
		 * @see WP_Widget::form()
		 *
		 * @param array $instance Previously saved values from database.
		 */
		public function form( $instance ) {

			$title    = ! empty( $instance['title'] ) ? $instance['title'] : '';
            $orderby  = ! empty( $instance['orderby'] ) ? $instance['orderby'] : 'click';
            $max      = ! empty( $instance['max'] ) ? intval( $instance['max'] ) : '3';
			$template = ! empty( $instance['template'] ) ? $instance['template'] : 'widget';
            $style    = ! empty( $instance['style'] ) ? $instance['style'] : 'standard';
			?>
            <!-- Title -->
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( esc_attr( 'Title:' ), 'affiliate-coupons-pro' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
            </p>

            <!-- Orderby -->
            <?php
            $orderby_options = array(
                'view' => __( 'Views', 'affiliate-coupons-pro' ),
                'copy' => __( 'Code Clicks', 'affiliate-coupons-pro' ),
                'click' => __( 'Link Clicks', 'affiliate-coupons-pro' )
            );
            ?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'orderby' ) ); ?>"><?php esc_attr_e( 'Order by:', 'affiliate-coupons-pro' ); ?></label>
                <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'orderby' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'orderby' ) ); ?>">
                    <?php foreach ( $orderby_options as $key => $label ) { ?>
                        <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $orderby, $key ); ?>><?php echo esc_attr( $label ); ?></option>
                    <?php } ?>
                </select>
            </p>

            <!-- Number of Coupons -->
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'max' ) ); ?>"><?php esc_attr_e( esc_attr( 'Number of Coupons:' ), 'affiliate-coupons-pro' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'max' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'max' ) ); ?>" type="number" value="<?php echo esc_attr( $max ); ?>">
            </p>

            <!-- Templates -->
			<?php
            $templates = affcoups_get_widget_template_options();
			?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'template' ) ); ?>"><?php esc_attr_e( 'Template:', 'affiliate-coupons-pro' ); ?></label>
                <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'template' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'template' ) ); ?>">
					<?php foreach ( $templates as $key => $label ) { ?>
                        <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $template, $key ); ?>><?php echo esc_attr( $label ); ?></option>
					<?php } ?>
                </select>
                <br/>
                <small>
					<?php esc_attr_e( 'The templates listed above are optimized for widgets.', 'affiliate-coupons-pro' ); ?>
                </small>
            </p>

            <!-- Styles -->
            <?php
            $styles = affcoups_get_style_options();
            ?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php esc_attr_e( 'Style:', 'affiliate-coupons-pro' ); ?></label>
                <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>">
                    <?php foreach ( $styles as $key => $label ) { ?>
                        <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $style, $key ); ?>><?php echo esc_attr( $label ); ?></option>
                    <?php } ?>
                </select>
            </p>
            <?php affcoups_the_pro_feature_note( __( 'More templates & styles', 'affiliate-coupons-pro' ), false ); ?>
			<?php
		}

		/**
		 * Sanitize widget form values as they are saved.
		 *
		 * @see WP_Widget::update()
		 *
		 * @param array $new_instance Values just sent to be saved.
		 * @param array $old_instance Previously saved values from database.
		 *
		 * @return array Updated safe values to be saved.
		 */
		public function update( $new_instance, $old_instance ) {
			$instance = array();

			$instance['title']    = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
            $instance['orderby']  = ( ! empty( $new_instance['orderby'] ) ) ? strip_tags( $new_instance['orderby'] ) : '';
            $instance['max']      = ( ! empty( $new_instance['max'] ) ) ? strip_tags( $new_instance['max'] ) : '';
			$instance['template'] = ( ! empty( $new_instance['template'] ) ) ? strip_tags( $new_instance['template'] ) : '';
            $instance['style'] = ( ! empty( $new_instance['style'] ) ) ? strip_tags( $new_instance['style'] ) : '';

			return $instance;
		}
	}

}