<?php
/**
 * Banner template
 *
 * @package AffiliateCouponsPro\Templates
 *
 * @var Affcoups_Coupon $coupon
 */

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

// Check if coupons were found
if ( ! isset( $coupons ) ) {
    return;
}

if ( ! isset( $args ) ) {
    $args = array();
}

do_action( 'affcoups_template_begin', $coupons, $args ); ?>

<div class="affcoups-banner">

    <?php if ( sizeof( $coupons ) > 0 ) {

        foreach( $coupons as $coupon ): ?>

            <div class="<?php $coupon->the_classes('affcoups-coupon' ); ?>"<?php $coupon->the_container(); ?>>

                <div class="affcoups-coupon__content">
                    <?php affcoups_tpl_the_coupon_button( $coupon, array(
                        'text' => $coupon->get_title(),
                        'text_forced' => true,
                        'code_reveal' => true
                    ) ); ?>
                </div>

                <?php if ( $coupon->get_description() ) { ?>
                    <div class="affcoups-coupon__footer">
                    </div>
                <?php } ?>

            </div>

        <?php endforeach;
     } else {
        esc_html_e( 'No coupons found.', 'affiliate-coupons-pro' );
    } ?>

</div>

<?php do_action( 'affcoups_after_template', $coupons, $args ); ?>