<?php
/**
 * Uninstall Affiliate Coupons Pro
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) exit;

// Load core file
include_once( 'affiliate-coupons-pro.php' );

$affcoups_options = affcoups_get_options();

if( isset( $affcoups_options['uninstall_on_delete'] ) && '1' == $affcoups_options['uninstall_on_delete'] ) {

	if ( is_multisite() ) {

		if ( true === version_compare( $GLOBALS['wp_version'], '4.6', '<' ) ) {
			$sites = wp_list_pluck( 'blog_id', wp_get_sites() );
		} else {
			$sites = get_sites( array( 'fields' => 'ids' ) );
		}

		// Remove all database tables
		foreach ( $sites as $site_id ) {

			switch_to_blog( $site_id );

            affcoups_pro_delete_options();
			affcoups_pro_uninstall_tables();

			restore_current_blog();

		}

	} else {

        affcoups_pro_delete_options();
        affcoups_pro_uninstall_tables();

	}
}

/**
 * Delete options
 */
function affcoups_pro_delete_options() {

    $options = array(
        'affcoups_pro_is_installed',
        'affcoups_pro_version'
    );

    foreach ( $options as $option ) {
        delete_option( $option );
    }
}


/**
 * Uninstalls all database tables created by our plugin.
 *
 * @since 1.0.0
 *
 * @global \wpdb $wpdb WordPress database abstraction layer.
 */
function affcoups_pro_uninstall_tables() {
	global $wpdb;

	$db_segments = array(
        'affcoups_stats'
	);

	foreach ( $db_segments as $segment ) {
		// Table.
		$wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . $segment );

		// Options.
		$wpdb->query( "DELETE FROM $wpdb->options WHERE option_name LIKE '%$segment%'" );
	}
}
