<?php

/**
 * @var bool $isRU
 */

use Travelpayouts\admin\components\DeactivationFeedback;

Travelpayouts::getInstance()->assets->loader->registerAsset('admin-deactivation-modal')->renderPreloader();
?>
<div class="travelpayouts-deactivation travelpayouts-deactivation--is-loading">
    <div class="travelpayouts-deactivation-modal travelpayouts-deactivation__backdrop"
         id="travelpayouts-deactivation-modal">
        <div class="deactivation-modal-content travelpayouts-deactivation__modal">

            <div class="travelpayouts-deactivation__header">
                <div class="travelpayouts-deactivation__logo">
                    <?php if ($isRU) : ?>
                        <svg width="147" height="35" viewBox="0 0 633 150" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M439.276 139.998C438.707 139.998 438.238 139.529 438.238 138.96V121.038C438.238 120.47 438.708 120 439.276 120H440.699C441.268 120 441.738 120.47 441.738 121.038V125.651H445.891C451.387 125.651 454.134 129.238 454.134 132.825C454.134 136.411 451.386 139.998 445.891 139.998H439.276ZM450.737 132.787C450.737 129.78 448.2 128.883 445.353 128.883H441.738V136.691H445.353C448.2 136.691 450.737 135.794 450.737 132.787ZM434.789 120C435.358 120 435.827 120.469 435.827 121.038V122.269C435.827 122.837 435.357 123.307 434.789 123.307H428.136V138.96C428.136 139.529 427.666 139.998 427.097 139.998H425.674C425.105 139.998 424.636 139.529 424.636 138.96V123.307H417.982C417.414 123.307 416.944 122.837 416.944 122.269V121.038C416.944 120.469 417.413 120 417.982 120H434.789ZM402.444 128.477H413.251V128.362C413.251 124.881 411.011 122.765 407.842 122.765C404.792 122.765 402.444 124.968 402.444 128.477ZM407.842 119.615C414.577 119.615 416.979 124.763 416.725 130.384C416.7 130.951 416.255 131.422 415.687 131.422H402.457V131.653C402.457 134.891 404.545 137.184 407.842 137.184C409.833 137.184 411.348 136.654 412.726 135.152C413.122 134.72 413.361 134.614 413.957 134.614H415.267C415.993 134.614 416.377 135.172 416.036 135.912C414.793 138.608 411.398 140.381 407.842 140.383C401.891 140.388 398.938 135.475 398.938 129.845C398.938 124.222 401.995 119.615 407.842 119.615ZM386.971 137.076C389.325 137.076 391.16 136.307 392.163 134.076C392.433 133.474 392.717 133.037 393.432 133.037H394.9C395.419 133.037 395.757 133.525 395.624 134.076C394.667 138.048 391.282 140.38 386.971 140.383C380.46 140.387 378.03 135.57 377.914 130.018C377.792 124.339 380.816 119.615 386.971 119.615C391.529 119.615 394.987 122.145 395.624 125.923C395.72 126.495 395.412 126.961 394.867 126.961H393.432C392.717 126.961 392.433 126.524 392.163 125.923C391.16 123.691 389.325 122.923 386.971 122.923C382.794 122.923 381.419 126.453 381.415 130.037C381.41 133.576 382.95 137.076 386.971 137.076Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M215.303 120C215.872 120 216.342 120.47 216.342 121.038V122.269C216.342 122.838 215.872 123.308 215.303 123.308H208.65V138.96C208.65 139.529 208.181 139.999 207.612 139.999H206.189C205.62 139.999 205.15 139.529 205.15 138.96V123.308H198.497C197.928 123.308 197.459 122.838 197.459 122.269V121.038C197.459 120.47 197.928 120 198.497 120H215.303ZM244.571 128.478H255.378V128.362C255.378 124.882 253.138 122.765 249.968 122.765C246.918 122.765 244.571 124.968 244.571 128.478ZM249.968 119.616C256.704 119.616 259.105 124.764 258.852 130.384C258.827 130.952 258.382 131.423 257.814 131.423H244.584V131.653C244.584 134.891 246.672 137.184 249.968 137.184C251.96 137.184 253.475 136.654 254.852 135.153C255.249 134.721 255.488 134.615 256.083 134.615H257.393C258.12 134.615 258.504 135.173 258.163 135.913C256.919 138.609 253.524 140.381 249.968 140.384C244.018 140.388 241.065 135.475 241.065 129.846C241.065 124.223 244.122 119.616 249.968 119.616ZM294.017 137.076C296.371 137.076 298.207 136.307 299.209 134.076C299.479 133.474 299.763 133.038 300.478 133.038H301.946C302.465 133.038 302.803 133.525 302.67 134.076C301.713 138.048 298.329 140.381 294.017 140.384C287.506 140.388 285.076 135.57 284.96 130.019C284.838 124.339 287.862 119.616 294.017 119.616C298.575 119.616 302.033 122.145 302.67 125.923C302.767 126.496 302.458 126.961 301.914 126.961H300.478C299.764 126.961 299.479 126.525 299.209 125.923C298.207 123.692 296.371 122.923 294.017 122.923C289.84 122.923 288.466 126.454 288.461 130.038C288.457 133.576 289.997 137.076 294.017 137.076ZM349.938 126.769C349.938 129.583 351.855 130.192 354.323 130.192H359.399V123.308H354.323C351.845 123.308 349.938 123.957 349.938 126.769ZM361.86 120C362.429 120 362.898 120.47 362.898 121.038V138.96C362.898 139.529 362.429 139.999 361.86 139.999H360.437C359.868 139.999 359.399 139.529 359.399 138.96V133.304H354.668L350.092 139.268C349.762 139.698 349.436 139.999 348.861 139.999H346.726C345.99 139.999 345.785 139.152 346.246 138.576L350.707 132.999C347.701 132.053 346.476 129.82 346.476 126.769C346.476 121.846 349.784 120 354.322 120H361.86ZM332.18 137.355C335.445 137.355 338.538 135.001 338.374 131.384L338.322 130.228L333.531 131.07C331.084 131.501 328.678 132.223 328.678 134.576C328.678 136.417 330.227 137.355 332.18 137.355ZM325.067 134.961C325.067 130.48 328.489 129.044 332.258 128.397L338.374 127.346C338.374 124.386 336.882 122.803 333.874 122.803C332.01 122.803 330.929 123.508 329.836 125C329.505 125.452 329.148 125.538 328.605 125.538H327.258C326.702 125.538 326.299 125.073 326.413 124.5C327.062 121.244 331.159 119.616 333.874 119.616C338.599 119.616 341.874 122.369 341.874 127.23V138.96C341.874 139.529 341.404 139.999 340.835 139.999H339.412C338.843 139.999 338.374 139.529 338.374 138.96V137.383C337.241 139.283 334.45 140.384 331.759 140.384C328.5 140.384 325.067 138.614 325.067 134.961ZM164.022 137.355C167.287 137.355 170.379 135.001 170.216 131.384L170.164 130.228L165.373 131.07C162.925 131.501 160.519 132.223 160.519 134.576C160.519 136.417 162.069 137.355 164.022 137.355ZM156.909 134.961C156.909 130.48 160.33 129.044 164.1 128.397L170.216 127.346C170.216 124.386 168.724 122.803 165.716 122.803C163.851 122.803 162.771 123.508 161.678 125C161.347 125.452 160.99 125.538 160.447 125.538H159.1C158.544 125.538 158.141 125.073 158.255 124.5C158.903 121.244 163 119.616 165.716 119.616C170.441 119.616 173.715 122.369 173.715 127.23V138.96C173.715 139.529 173.246 139.999 172.677 139.999H171.254C170.685 139.999 170.216 139.529 170.216 138.96V137.383C169.083 139.283 166.292 140.384 163.601 140.384C160.342 140.384 156.909 138.614 156.909 134.961ZM310.504 127.39L318.503 120.654C318.963 120.266 319.38 120 320.003 120H321.739C322.624 120 323.224 120.704 322.254 121.513L313.137 129.117L323.039 138.283C323.726 138.919 323.703 139.911 322.832 139.936L320.734 139.999C320.149 140.016 319.58 139.753 319.157 139.345L310.504 130.997V138.96C310.504 139.529 310.034 139.999 309.465 139.999H308.042C307.474 139.999 307.004 139.529 307.004 138.96V121.038C307.004 120.47 307.474 120 308.042 120H309.465C310.034 120 310.504 120.47 310.504 121.038V127.39ZM266.686 129.865C266.686 133.664 267.719 137.076 272.301 137.076C276.568 137.076 277.935 133.773 277.935 130C277.935 126.29 276.614 122.923 272.301 122.923C267.872 122.923 266.686 126.127 266.686 129.865ZM272.685 140.384C270.382 140.384 268.163 139.662 266.724 137.768V146.267C266.724 146.836 266.255 147.306 265.686 147.306H264.263C263.695 147.306 263.224 146.836 263.224 146.267V121.038C263.224 120.47 263.694 120 264.263 120H265.686C266.255 120 266.724 120.47 266.724 121.038V122.231C268.154 120.302 270.368 119.616 272.685 119.616C278.863 119.616 281.454 124.61 281.454 130.019C281.454 135.564 278.724 140.384 272.685 140.384ZM182.51 129.865C182.51 133.664 183.544 137.076 188.125 137.076C192.393 137.076 193.76 133.773 193.76 130C193.76 126.29 192.439 122.923 188.125 122.923C183.697 122.923 182.51 126.127 182.51 129.865ZM188.51 140.384C186.207 140.384 183.988 139.662 182.549 137.768V146.267C182.549 146.836 182.079 147.306 181.51 147.306H180.087C179.519 147.306 179.049 146.836 179.049 146.267V121.038C179.049 120.47 179.519 120 180.087 120H181.51C182.079 120 182.549 120.47 182.549 121.038V122.231C183.978 120.302 186.193 119.616 188.51 119.616C194.688 119.616 197.278 124.61 197.278 130.019C197.278 135.564 194.548 140.384 188.51 140.384ZM255.545 115.885C255.545 116.454 255.075 116.924 254.506 116.924H252.314C251.746 116.924 251.276 116.454 251.276 115.885V113.693C251.276 113.125 251.746 112.655 252.314 112.655H254.506C255.075 112.655 255.545 113.125 255.545 113.693V115.885ZM248.584 115.885C248.584 116.454 248.114 116.924 247.545 116.924H245.353C244.785 116.924 244.315 116.454 244.315 115.885V113.693C244.315 113.125 244.785 112.655 245.353 112.655H247.545C248.114 112.655 248.584 113.125 248.584 113.693V115.885ZM235.559 120C236.128 120 236.597 120.47 236.597 121.038V138.96C236.597 139.529 236.128 139.999 235.559 139.999H234.136C233.567 139.999 233.098 139.529 233.098 138.96V131.461H222.252V138.96C222.252 139.529 221.783 139.999 221.214 139.999H219.791C219.198 139.999 218.752 139.556 218.752 138.96V121.038C218.752 120.47 219.222 120 219.791 120H221.214C221.783 120 222.252 120.47 222.252 121.038V128.154H233.098V121.038C233.098 120.47 233.567 120 234.136 120H235.559ZM151.806 120C152.375 120 152.845 120.47 152.845 121.038V138.96C152.845 139.529 152.375 139.999 151.806 139.999H150.383C149.815 139.999 149.345 139.529 149.345 138.96V123.308H138.499V138.96C138.499 139.529 138.03 139.999 137.461 139.999H136.038C135.469 139.999 135 139.529 135 138.96V121.038C135 120.47 135.47 120 136.038 120H151.806Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M218.524 71.7329C216.938 72.7594 214.384 74.0004 211.644 74.0004C208.665 74.0004 207.392 72.7811 207.392 70.3006C207.392 67.8266 209.109 66.5361 212.466 66.5361H218.525L218.524 71.7329ZM210.606 58.282C201.879 58.282 194.89 62.7138 194.89 72.6325C194.89 80.5258 200.222 84.7455 207.965 84.7455C213.388 84.7455 217.223 82.5848 219.523 80.5835L220.044 82.702C220.25 83.5423 221.004 84.1335 221.87 84.1335H229.16C230.196 84.1335 231.077 83.2948 231.08 82.2585V56.08C231.08 48.0435 227.328 41.3945 214.355 41.3945C208.551 41.3945 203.831 42.1753 199.814 43.2798C199.005 43.5018 198.456 44.2498 198.456 45.0875V50.2548C198.456 51.2935 199.298 52.1358 200.336 52.1358L212.837 52.137C215.794 52.137 218.528 53.3373 218.528 56.908L218.527 58.282H210.606Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M134.92 68.9478C134.92 79.5908 139.145 84.7458 148.985 84.7458C153.221 84.7458 156.992 83.7363 159.295 82.781C159.988 82.4935 160.424 81.8048 160.424 81.0555V75.8815C160.424 74.8428 159.582 74.0008 158.543 74.0005L151.798 73.999C149.43 73.9985 147.511 72.0783 147.512 69.7108L147.515 52.7458H156.668C157.747 52.7458 158.622 51.8708 158.622 50.7915V43.954C158.622 42.875 157.747 42 156.668 42H147.517L147.519 30.2363C147.519 28.9355 146.23 28.027 145.005 28.4648L136.249 31.5918C135.501 31.8588 135.002 32.5655 135 33.3593L134.981 42H129.954C128.874 42 128 42.875 128 43.954V50.7915C128 51.8708 128.874 52.7458 129.954 52.7458H134.956L134.92 68.9478Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M191.455 41.3945C184.482 41.3945 180.302 44.2828 178.635 45.7408L178.129 43.4715C177.937 42.6115 177.174 41.9998 176.294 41.9998H169.041C168.001 41.9998 167.159 42.8418 167.159 43.8808V82.2533C167.159 83.2923 168.001 84.1343 169.041 84.1343H177.793C178.832 84.1343 179.674 83.2923 179.674 82.2533V54.7015C181.177 53.2818 183.577 52.137 188.955 52.137H191.602C192.64 52.137 193.483 51.2953 193.483 50.2565V43.2775C193.483 42.1845 192.548 41.3945 191.455 41.3945Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M247.887 43.314C247.649 42.529 246.914 42 246.094 42H236.165C235.102 42 234.283 42.8348 234.283 43.8403C234.283 44.0665 234.315 44.299 234.4 44.5298L248.498 82.9023C248.77 83.6425 249.475 84.1345 250.264 84.1345H259.512C260.3 84.1345 261.005 83.6425 261.277 82.9023L275.376 44.5298C275.46 44.3008 275.493 44.069 275.493 43.844C275.493 42.854 274.675 42 273.611 42H264.178C263.357 42 262.623 42.529 262.384 43.314L255.136 67.1858L247.887 43.314Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M491.108 74.0007C487.68 74.0007 484.421 71.8362 484.421 63.0687C484.421 54.3017 487.68 52.1372 491.108 52.1372C494.535 52.1372 497.794 54.3017 497.794 63.0687C497.794 71.8362 494.535 74.0007 491.108 74.0007ZM491.108 41.3945C478.353 41.3945 471.831 48.9958 471.831 63.067C471.831 77.1375 478.353 84.7455 491.108 84.7455C503.862 84.7455 510.384 77.1375 510.384 63.067C510.384 48.9958 503.862 41.3945 491.108 41.3945Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M467.73 42H458.756C457.794 42 456.94 42.615 456.635 43.527L449.284 65.5105L441.55 43.304C441.278 42.5235 440.542 42 439.715 42H429.778C428.676 42 427.834 42.796 427.834 43.9033C427.834 44.159 427.875 44.4225 427.981 44.681L443.135 81.5948L436.263 99.8725C435.798 101.103 436.707 102.418 438.023 102.418H446.896C447.683 102.418 448.388 101.928 448.66 101.189L469.553 44.616C469.638 44.3843 469.675 44.15 469.675 43.9218C469.675 42.8928 468.836 42 467.73 42Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M622.374 59.4175C620.15 58.7155 615.702 57.3113 613.478 56.6095C612.13 56.1843 610.829 55.7838 610.829 54.4765C610.829 52.7515 612.531 52.1375 615.65 52.1375L627.505 52.137C628.545 52.137 629.379 51.2953 629.379 50.256V44.932C629.379 44.0998 628.833 43.3563 628.033 43.1275C623.724 41.8955 620.08 41.3945 615.142 41.3945C607.978 41.3945 597.979 44.3308 597.979 54.8533C597.979 57.3805 598.711 63.2945 605.731 65.5215C608.606 66.4335 614.356 68.2578 617.231 69.1703C618.342 69.5225 619.369 70.2835 619.369 71.6885C619.369 73.3135 618.171 74.0008 616.174 74.0008H601.031C599.992 74.0008 599.15 74.8425 599.15 75.8813V81.1565C599.15 81.986 599.684 82.711 600.476 82.9553C602.624 83.617 607.033 84.7458 613.874 84.7458C631.748 84.7458 632.56 74.7055 632.56 70.921C632.56 66.1235 629.864 61.782 622.374 59.4175Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M412.269 71.7329C410.683 72.7594 408.129 74.0004 405.389 74.0004C402.41 74.0004 401.137 72.7811 401.137 70.3006C401.137 67.8266 402.854 66.5361 406.211 66.5361H412.27L412.269 71.7329ZM408.1 41.3945C402.296 41.3945 397.576 42.1753 393.559 43.2798C392.751 43.5018 392.201 44.2498 392.201 45.088V50.2548C392.201 51.2935 393.043 52.1358 394.082 52.1358H406.582C409.539 52.1358 412.273 53.3373 412.273 56.908L412.273 58.282H404.351C395.624 58.282 388.636 62.7138 388.636 72.6325C388.636 80.5258 393.968 84.7455 401.71 84.7455C407.133 84.7455 410.969 82.5848 413.268 80.5835L413.789 82.702C413.995 83.5423 414.749 84.1335 415.615 84.1335H422.941C423.98 84.1335 424.823 83.2915 424.823 82.253V56.08C424.823 48.0435 421.073 41.3945 408.1 41.3945Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M552.082 42H543.33C542.291 42 541.449 42.842 541.449 43.881V71.782C539.668 72.9908 537.321 74.0008 534.83 74.0008C531.036 74.0008 530.073 71.8085 530.073 67.2238V43.884C530.073 42.8453 529.231 42.003 528.192 42.003H519.439C518.4 42.003 517.559 42.8453 517.559 43.884V66.8288C517.559 72.0683 516.869 84.7458 530.352 84.7458C535.584 84.7458 539.772 82.9918 542.576 80.4825L543.014 82.6293C543.192 83.5055 543.963 84.1345 544.857 84.1345H552.082C553.121 84.1345 553.963 83.2925 553.963 82.2535V43.881C553.963 42.842 553.121 42 552.082 42Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M591.473 74.0005L584.728 73.999C582.36 73.9985 580.441 72.0785 580.441 69.7108L580.445 52.7458H589.598C590.676 52.7458 591.551 51.8708 591.551 50.7915V43.954C591.551 42.875 590.676 42 589.598 42H580.446L580.449 30.2363C580.449 28.9355 579.16 28.027 577.935 28.4648L569.178 31.5918C568.431 31.8588 567.932 32.5655 567.93 33.3593L567.911 42H562.883C561.804 42 560.929 42.875 560.929 43.954V50.7915C560.929 51.8708 561.804 52.7458 562.883 52.7458H567.886L567.85 68.9478C567.85 79.5908 572.074 84.7458 581.915 84.7458C586.151 84.7458 589.922 83.7363 592.225 82.781C592.917 82.4935 593.354 81.8048 593.354 81.0555V75.8815C593.354 74.8428 592.512 74.0008 591.473 74.0005Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M335.172 82.2538L335.179 23.2125C335.179 21.912 333.891 21.0037 332.666 21.4412L323.91 24.568C323.162 24.835 322.663 25.5427 322.662 26.3365V82.251C322.661 83.2908 323.424 84.1343 324.464 84.1343H333.292C334.33 84.1343 335.172 83.2925 335.172 82.2538Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M296.863 52.1372C301.886 52.1372 302.699 56.6177 302.699 58.6475H290.945C290.945 54.1562 293.435 52.1372 296.863 52.1372ZM312.206 75.4998C312.206 74.6715 311.535 74.0005 310.707 74.0005L299.441 73.999C294.411 73.999 290.669 72.7128 290.669 66.8593H311.577C313.926 66.8593 315.001 65.9428 315.001 62.4573C315.001 46.769 306.862 41.3945 296.863 41.3945C284.109 41.3945 277.587 49.4343 277.587 63.0558C277.587 74.7878 281.681 84.7455 297.36 84.7455C302.624 84.7455 307.407 84.035 310.858 82.986C311.659 82.7423 312.206 82.014 312.206 81.177V75.4998Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M363.064 74.0007C360.857 74.0007 358.979 73.621 357.476 73.1435V54.7432C359.055 53.3752 361.398 52.1372 363.801 52.1372C367.311 52.1372 370.927 54.623 370.927 63.0672C370.927 71.3652 367.492 74.0007 363.064 74.0007ZM367.817 41.3945C362.51 41.3945 358.762 43.6905 356.482 45.939L355.932 43.4715C355.74 42.6113 354.977 41.9998 354.096 41.9998H346.843C345.804 41.9998 344.962 42.8415 344.962 43.8808V100.537C344.962 101.576 345.804 102.418 346.843 102.418H355.595C356.634 102.418 357.476 101.576 357.476 100.537V83.733C359.452 84.322 361.843 84.7455 364.679 84.7455C377.155 84.7455 383.473 76.642 383.473 62.571C383.473 49.0995 377.981 41.3945 367.817 41.3945Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M97.7496 108.026H71.9996C69.7906 108.026 67.9996 106.235 67.9996 104.026V84H91.4761C92.5756 84 93.5138 83.2055 93.6954 82.1212L95.2851 72.6212C95.5146 71.2495 94.4569 70 93.0659 70H53.9996V104.026C53.9996 113.968 62.0584 122.026 71.9996 122.026H85.9996V132.438C79.0729 135.069 73.1451 136 65.5071 136C46.0154 136 34.5405 125.179 33.9996 106V70H3.83985C2.7406 70 1.8021 70.7945 1.62085 71.8788L0.030854 81.3787C-0.198396 82.7505 0.859104 84 2.2501 84H19.9996V106C20.3068 118 23.4216 129.018 32.1071 137.773C40.0429 145.772 51.5924 150 65.5071 150C77.2306 150 86.1139 148.062 97.7046 142.642C99.1074 141.986 99.9996 140.572 99.9996 139.023V110.276C99.9996 109.034 98.9924 108.026 97.7496 108.026Z"
                                  fill="#0085FF"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M6.93589 55.9999H33.9996V25.9599L53.9996 18.8777V55.9999H96.1594C97.2586 55.9999 98.1969 55.2054 98.3784 54.1212L99.9681 44.6212C100.198 43.2494 99.1399 41.9999 97.7489 41.9999H67.9996V2.25168C67.9996 0.69843 66.4629 -0.38757 64.9984 0.13093L21.4984 15.5349C20.6001 15.8532 19.9996 16.7029 19.9996 17.6559V41.9999H8.52564C7.42639 41.9999 6.48789 42.7944 6.30639 43.8787L4.71689 53.3787C4.48714 54.7504 5.54489 55.9999 6.93589 55.9999Z"
                                  fill="#0085FF"></path>
                        </svg>
                    <?php else : ?>
                        <svg width="147" height="35" viewBox="0 0 633 150" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M246.133 128.479H256.942V128.364C256.942 124.883 254.701 122.766 251.531 122.766C248.48 122.766 246.133 124.969 246.133 128.479ZM251.531 119.615C258.268 119.615 260.67 124.765 260.417 130.386C260.391 130.954 259.946 131.425 259.378 131.425H246.146V131.656C246.146 134.894 248.234 137.188 251.531 137.188C253.523 137.188 255.038 136.658 256.416 135.156C256.813 134.724 257.051 134.618 257.647 134.618H258.958C259.684 134.618 260.068 135.176 259.727 135.916C258.483 138.613 255.088 140.385 251.531 140.388C245.58 140.393 242.626 135.479 242.626 129.848C242.626 124.223 245.684 119.615 251.531 119.615ZM144.555 137.358C147.82 137.358 150.913 135.004 150.75 131.386L150.698 130.23L145.906 131.073C143.458 131.503 141.052 132.225 141.052 134.579C141.052 136.421 142.601 137.358 144.555 137.358ZM137.441 134.964C137.441 130.482 140.862 129.046 144.633 128.398L150.75 127.347C150.75 124.387 149.258 122.804 146.249 122.804C144.384 122.804 143.304 123.508 142.21 125.001C141.879 125.453 141.522 125.539 140.979 125.539H139.632C139.076 125.539 138.673 125.074 138.787 124.501C139.435 121.244 143.533 119.615 146.249 119.615C150.974 119.615 154.25 122.37 154.25 127.232V138.964C154.25 139.533 153.78 140.003 153.211 140.003H151.788C151.219 140.003 150.75 139.533 150.75 138.964V137.387C149.616 139.288 146.825 140.388 144.134 140.388C140.874 140.388 137.441 138.618 137.441 134.964ZM215.379 137.358C218.644 137.358 221.737 135.004 221.574 131.386L221.522 130.23L216.73 131.073C214.282 131.503 211.876 132.225 211.876 134.579C211.876 136.421 213.425 137.358 215.379 137.358ZM208.265 134.964C208.265 130.482 211.687 129.046 215.457 128.398L221.574 127.347C221.574 124.387 220.082 122.804 217.073 122.804C215.208 122.804 214.128 123.508 213.034 125.001C212.704 125.453 212.346 125.539 211.804 125.539H210.456C209.9 125.539 209.497 125.074 209.611 124.501C210.26 121.244 214.357 119.615 217.073 119.615C221.799 119.615 225.074 122.37 225.074 127.232V138.964C225.074 139.533 224.605 140.003 224.036 140.003H222.612C222.044 140.003 221.574 139.533 221.574 138.964V137.387C220.44 139.288 217.649 140.388 214.958 140.388C211.698 140.388 208.265 138.618 208.265 134.964ZM235.279 133.272C235.279 135.498 236.008 136.695 238.388 136.695H240.349C240.912 136.695 241.348 137.181 241.348 137.734V138.965C241.348 139.518 240.913 140.003 240.349 140.003H238.017C233.589 140.003 231.911 137.468 231.911 133.272V123.309H229.173C228.609 123.309 228.173 122.822 228.173 122.27V121.039C228.173 120.486 228.609 120 229.173 120H231.911V113.73C231.911 113.178 232.347 112.691 232.91 112.691H234.28C234.843 112.691 235.279 113.178 235.279 113.73V120H239.979C240.542 120 240.978 120.486 240.978 121.039V122.27C240.978 122.822 240.542 123.309 239.979 123.309H235.279V133.272ZM204.729 115.923C204.729 116.475 204.294 116.961 203.73 116.961H201.621C201.057 116.961 200.622 116.475 200.622 115.923V113.73C200.622 113.178 201.057 112.691 201.621 112.691H203.73C204.293 112.691 204.729 113.178 204.729 113.73V115.923ZM204.359 138.965C204.359 139.517 203.924 140.003 203.36 140.003H201.991C201.427 140.003 200.991 139.517 200.991 138.965V121.039C200.991 120.486 201.428 120 201.991 120H203.36C203.924 120 204.359 120.486 204.359 121.039V138.965ZM195.08 138.965C195.08 139.518 194.644 140.003 194.08 140.003H192.711C192.148 140.003 191.712 139.517 191.712 138.965V113.73C191.712 113.178 192.148 112.691 192.711 112.691H194.08C194.644 112.691 195.08 113.178 195.08 113.73V138.965ZM185.8 138.965C185.8 139.517 185.364 140.003 184.8 140.003H183.431C182.868 140.003 182.432 139.517 182.432 138.965V123.309H175.734V138.965C175.734 139.518 175.298 140.003 174.735 140.003H173.365C172.802 140.003 172.366 139.517 172.366 138.965V123.309H164.558V138.965C164.558 139.517 164.122 140.003 163.559 140.003H162.189C161.626 140.003 161.19 139.517 161.19 138.965V123.309H158.082C157.518 123.309 157.082 122.822 157.082 122.27V121.039C157.082 120.486 157.518 120 158.082 120H161.19V118.077C161.19 113.844 162.901 111.538 167.296 111.538H169.628C170.191 111.538 170.627 112.024 170.627 112.576V113.807C170.627 114.359 170.191 114.845 169.628 114.845H167.666C165.286 114.845 164.558 116.044 164.558 118.269V120H172.366V118.077C172.366 113.845 174.077 111.538 178.472 111.538H184.8C185.364 111.538 185.8 112.023 185.8 112.576V113.807C185.8 114.36 185.364 114.845 184.8 114.845H178.842C176.424 114.845 175.734 116.095 175.734 118.269V120H184.8C185.364 120 185.8 120.486 185.8 121.039V138.965Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M298.773 128.479H309.582V128.364C309.582 124.882 307.341 122.766 304.171 122.766C301.12 122.766 298.773 124.969 298.773 128.479ZM304.171 119.615C310.908 119.615 313.31 124.764 313.056 130.385C313.031 130.953 312.586 131.424 312.018 131.424H298.786V131.655C298.786 134.893 300.874 137.187 304.171 137.187C306.163 137.187 307.678 136.657 309.056 135.155C309.453 134.723 309.691 134.616 310.287 134.616H311.597C312.324 134.616 312.709 135.175 312.367 135.915C311.123 138.611 307.728 140.384 304.171 140.386C298.22 140.391 295.266 135.478 295.266 129.847C295.266 124.223 298.324 119.615 304.171 119.615ZM398.767 127.39L406.768 120.653C407.228 120.265 407.645 119.999 408.268 119.999H410.004C410.89 119.999 411.489 120.703 410.519 121.512L401.401 129.117L411.304 138.285C411.992 138.921 411.969 139.976 411.098 140.001H408.999C408.414 140.018 407.845 139.755 407.422 139.347L398.767 130.998V138.962C398.767 139.531 398.297 140.001 397.729 140.001H396.305C395.739 140.001 395.267 139.531 395.267 138.962V113.75C395.267 113.181 395.737 112.711 396.305 112.711H397.729C398.298 112.711 398.767 113.184 398.767 113.75V127.39ZM391.788 120C392.351 120 392.787 120.486 392.787 121.038V122.269C392.787 122.822 392.351 123.308 391.788 123.308H389.642C386.805 123.308 385.386 124.783 385.386 127.731V138.963C385.386 139.516 384.95 140.002 384.387 140.002H383.018C382.454 140.002 382.018 139.516 382.018 138.963V121.038C382.018 120.486 382.454 120 383.018 120H384.387C384.95 120 385.386 120.486 385.386 121.038V122.231C385.88 121.462 386.471 120.898 387.162 120.538C387.853 120.179 388.753 120 389.864 120H391.788ZM374.025 130.02C374.025 126.362 372.831 122.924 368.548 122.924C364.266 122.924 363.071 126.362 363.071 130.02C363.071 133.664 364.298 137.079 368.548 137.079C372.798 137.079 374.025 133.664 374.025 130.02ZM368.548 119.615C374.97 119.615 377.355 124.297 377.355 130.02C377.355 135.726 374.928 140.386 368.548 140.386C362.206 140.386 359.703 135.719 359.703 130.02C359.703 124.311 362.183 119.615 368.548 119.615ZM349.563 133.771L353.708 120.923C353.913 120.356 354.356 120 354.966 120H356.188C356.857 120 357.181 120.634 357.039 121.231L351.377 138.924C351.196 139.491 350.935 140.002 350.267 140.002H349.119C348.463 140.002 348.204 139.454 347.972 138.924L343.568 126.154L339.164 138.924C338.933 139.454 338.674 140.002 338.017 140.002H336.87C336.2 140.002 335.942 139.493 335.76 138.924L330.098 121.231C329.955 120.635 330.28 120 330.949 120H332.17C332.78 120 333.224 120.356 333.428 120.923L337.573 133.771L342.014 120.923C342.219 120.356 342.522 120 343.161 120H343.975C344.614 120 344.918 120.356 345.123 120.923L349.563 133.771ZM322.437 133.271C322.437 135.576 323.233 136.694 325.546 136.694H327.507C328.071 136.694 328.506 137.18 328.506 137.732V138.963C328.506 139.516 328.071 140.002 327.507 140.002H325.176C320.747 140.002 319.07 137.467 319.07 133.271V123.308H316.331C315.768 123.308 315.332 122.822 315.332 122.269V121.039C315.332 120.486 315.768 120 316.331 120H319.07V113.73C319.07 113.178 319.505 112.692 320.069 112.692H321.438C322.001 112.692 322.437 113.178 322.437 113.73V120H327.137C327.701 120 328.136 120.486 328.136 121.039V122.269C328.136 122.822 327.701 123.308 327.137 123.308H322.437V133.271ZM291.573 138.963C291.573 139.516 291.138 140.002 290.575 140.002H289.205C288.641 140.002 288.206 139.516 288.206 138.963V128.808C288.206 125.364 286.72 122.923 283.025 122.923C279.406 122.923 277.844 125.433 277.844 128.808V138.963C277.844 139.516 277.408 140.002 276.845 140.002H275.475C274.912 140.002 274.476 139.516 274.476 138.963V121.038C274.476 120.486 274.912 120 275.475 120H276.845C277.408 120 277.844 120.486 277.844 121.038V122.231C279.199 120.377 281.351 119.615 283.58 119.615C288.683 119.615 291.573 123.334 291.573 128.231V138.963Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M218.525 71.7329C216.939 72.7594 214.384 74.0004 211.644 74.0004C208.665 74.0004 207.393 72.7811 207.393 70.3006C207.393 67.8266 209.11 66.5361 212.467 66.5361H218.526L218.525 71.7329ZM210.606 58.282C201.88 58.282 194.891 62.7138 194.891 72.6325C194.891 80.5258 200.223 84.7455 207.965 84.7455C213.388 84.7455 217.224 82.5848 219.523 80.5835L220.044 82.702C220.251 83.5423 221.004 84.1335 221.871 84.1335H229.16C230.197 84.1335 231.078 83.2948 231.081 82.2585V56.08C231.081 48.0435 227.328 41.3945 214.355 41.3945C208.552 41.3945 203.832 42.1753 199.814 43.2798C199.006 43.5018 198.456 44.2498 198.456 45.0875V50.2548C198.456 51.2935 199.298 52.1358 200.337 52.1358L212.838 52.137C215.794 52.137 218.528 53.3373 218.528 56.908L218.528 58.282H210.606Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M134.92 68.9478C134.92 79.5908 139.145 84.7458 148.985 84.7458C153.221 84.7458 156.993 83.7363 159.296 82.781C159.988 82.4935 160.424 81.8048 160.424 81.0555V75.8815C160.424 74.8428 159.582 74.0008 158.544 74.0005L151.799 73.999C149.431 73.9985 147.512 72.0783 147.512 69.7108L147.515 52.7458H156.668C157.747 52.7458 158.622 51.8708 158.622 50.7915V43.954C158.622 42.875 157.747 42 156.668 42H147.517L147.519 30.2363C147.519 28.9355 146.23 28.027 145.005 28.4648L136.249 31.5918C135.501 31.8588 135.002 32.5655 135.001 33.3593L134.981 42H129.954C128.875 42 128 42.875 128 43.954V50.7915C128 51.8708 128.875 52.7458 129.954 52.7458H134.957L134.92 68.9478Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M191.455 41.3945C184.483 41.3945 180.302 44.2828 178.636 45.7408L178.129 43.4715C177.938 42.6115 177.175 41.9998 176.294 41.9998H169.041C168.002 41.9998 167.16 42.8418 167.16 43.8808V82.2533C167.16 83.2923 168.002 84.1343 169.041 84.1343H177.794C178.832 84.1343 179.675 83.2923 179.675 82.2533V54.7015C181.178 53.2818 183.578 52.137 188.955 52.137H191.602C192.641 52.137 193.483 51.2953 193.483 50.2565V43.2775C193.483 42.1845 192.549 41.3945 191.455 41.3945Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M247.888 43.314C247.649 42.529 246.914 42 246.094 42H236.165C235.103 42 234.283 42.8347 234.283 43.8403C234.283 44.0665 234.315 44.299 234.4 44.5298L248.499 82.9022C248.771 83.6425 249.476 84.1345 250.264 84.1345H259.512C260.301 84.1345 261.005 83.6425 261.278 82.9022L275.377 44.5298C275.461 44.3008 275.494 44.069 275.494 43.844C275.494 42.854 274.675 42 273.612 42H264.178C263.358 42 262.623 42.529 262.385 43.314L255.136 67.1857L247.888 43.314Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M491.108 74.0007C487.68 74.0007 484.422 71.8362 484.422 63.0687C484.422 54.3017 487.68 52.1372 491.108 52.1372C494.536 52.1372 497.794 54.3017 497.794 63.0687C497.794 71.8362 494.536 74.0007 491.108 74.0007ZM491.108 41.3945C478.354 41.3945 471.832 48.9958 471.832 63.067C471.832 77.1375 478.354 84.7455 491.108 84.7455C503.863 84.7455 510.385 77.1375 510.385 63.067C510.385 48.9958 503.863 41.3945 491.108 41.3945Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M467.73 42H458.756C457.795 42 456.941 42.615 456.635 43.527L449.284 65.5105L441.551 43.304C441.278 42.5235 440.543 42 439.715 42H429.779C428.676 42 427.834 42.796 427.834 43.9032C427.834 44.159 427.876 44.4225 427.981 44.681L443.136 81.5947L436.263 99.8725C435.798 101.103 436.707 102.418 438.023 102.418H446.897C447.684 102.418 448.388 101.927 448.661 101.189L469.553 44.616C469.639 44.3842 469.675 44.15 469.675 43.9217C469.675 42.8927 468.836 42 467.73 42Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M622.375 59.4175C620.151 58.7155 615.703 57.3113 613.479 56.6095C612.13 56.1843 610.83 55.7838 610.83 54.4765C610.83 52.7515 612.531 52.1375 615.651 52.1375L627.506 52.137C628.545 52.137 629.38 51.2953 629.38 50.256V44.932C629.38 44.0998 628.833 43.3563 628.033 43.1275C623.725 41.8955 620.08 41.3945 615.143 41.3945C607.978 41.3945 597.979 44.3308 597.979 54.8533C597.979 57.3805 598.712 63.2945 605.731 65.5215C608.607 66.4335 614.357 68.2578 617.232 69.1703C618.342 69.5225 619.37 70.2835 619.37 71.6885C619.37 73.3135 618.172 74.0008 616.174 74.0008H601.031C599.993 74.0008 599.15 74.8425 599.15 75.8813V81.1565C599.15 81.986 599.684 82.711 600.477 82.9553C602.624 83.617 607.033 84.7458 613.874 84.7458C631.749 84.7458 632.561 74.7055 632.561 70.921C632.561 66.1235 629.864 61.782 622.375 59.4175Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M412.27 71.7329C410.684 72.7594 408.13 74.0004 405.389 74.0004C402.411 74.0004 401.138 72.7811 401.138 70.3006C401.138 67.8266 402.854 66.5361 406.212 66.5361H412.271L412.27 71.7329ZM408.1 41.3945C402.297 41.3945 397.577 42.1753 393.559 43.2798C392.751 43.5018 392.201 44.2498 392.201 45.088V50.2548C392.201 51.2935 393.043 52.1358 394.082 52.1358H406.583C409.54 52.1358 412.273 53.3373 412.273 56.908L412.273 58.282H404.352C395.625 58.282 388.636 62.7138 388.636 72.6325C388.636 80.5258 393.968 84.7455 401.711 84.7455C407.133 84.7455 410.969 82.5848 413.268 80.5835L413.789 82.702C413.996 83.5423 414.75 84.1335 415.616 84.1335H422.942C423.981 84.1335 424.823 83.2915 424.823 82.253V56.08C424.823 48.0435 421.073 41.3945 408.1 41.3945Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M552.083 42H543.33C542.292 42 541.449 42.842 541.449 43.881V71.782C539.668 72.9907 537.322 74.0008 534.83 74.0008C531.037 74.0008 530.073 71.8085 530.073 67.2237V43.884C530.073 42.8453 529.231 42.003 528.193 42.003H519.44C518.401 42.003 517.559 42.8453 517.559 43.884V66.8288C517.559 72.0683 516.87 84.7458 530.353 84.7458C535.585 84.7458 539.772 82.9917 542.577 80.4825L543.015 82.6292C543.193 83.5055 543.964 84.1345 544.857 84.1345H552.083C553.122 84.1345 553.964 83.2925 553.964 82.2535V43.881C553.964 42.842 553.122 42 552.083 42Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M591.474 74.0005L584.728 73.999C582.36 73.9985 580.442 72.0785 580.442 69.7108L580.445 52.7458H589.598C590.677 52.7458 591.552 51.8708 591.552 50.7915V43.954C591.552 42.875 590.677 42 589.598 42H580.446L580.449 30.2363C580.449 28.9355 579.16 28.027 577.935 28.4648L569.179 31.5918C568.431 31.8588 567.932 32.5655 567.93 33.3593L567.911 42H562.884C561.805 42 560.93 42.875 560.93 43.954V50.7915C560.93 51.8708 561.805 52.7458 562.884 52.7458H567.887L567.85 68.9478C567.85 79.5908 572.075 84.7458 581.915 84.7458C586.151 84.7458 589.922 83.7363 592.226 82.781C592.918 82.4935 593.354 81.8048 593.354 81.0555V75.8815C593.354 74.8428 592.512 74.0008 591.474 74.0005Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M335.173 82.2537L335.179 23.2125C335.18 21.912 333.891 21.0037 332.666 21.4412L323.91 24.568C323.163 24.835 322.663 25.5427 322.662 26.3365V82.251C322.661 83.2907 323.424 84.1342 324.464 84.1342H333.292C334.331 84.1342 335.173 83.2925 335.173 82.2537Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M296.864 52.1372C301.887 52.1372 302.699 56.6177 302.699 58.6475H290.946C290.946 54.1562 293.436 52.1372 296.864 52.1372ZM312.207 75.4998C312.207 74.6715 311.536 74.0005 310.708 74.0005L299.442 73.999C294.412 73.999 290.67 72.7128 290.67 66.8593H311.578C313.926 66.8593 315.001 65.9428 315.001 62.4573C315.001 46.769 306.863 41.3945 296.864 41.3945C284.109 41.3945 277.588 49.4343 277.588 63.0558C277.588 74.7878 281.682 84.7455 297.361 84.7455C302.624 84.7455 307.408 84.035 310.859 82.986C311.659 82.7423 312.207 82.014 312.207 81.177V75.4998Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M363.065 74.0007C360.858 74.0007 358.98 73.621 357.477 73.1435V54.7432C359.055 53.3752 361.398 52.1372 363.802 52.1372C367.312 52.1372 370.927 54.623 370.927 63.0672C370.927 71.3652 367.492 74.0007 363.065 74.0007ZM367.817 41.3945C362.51 41.3945 358.763 43.6905 356.482 45.939L355.932 43.4715C355.74 42.6113 354.977 41.9998 354.096 41.9998H346.843C345.804 41.9998 344.963 42.8415 344.963 43.8808V100.537C344.963 101.576 345.804 102.418 346.843 102.418H355.596C356.635 102.418 357.477 101.576 357.477 100.537V83.733C359.452 84.322 361.843 84.7455 364.679 84.7455C377.155 84.7455 383.473 76.642 383.473 62.571C383.473 49.0995 377.981 41.3945 367.817 41.3945Z"
                                  class="logo_text"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M97.7501 108.026H72.0001C69.7911 108.026 68.0001 106.235 68.0001 104.026V84H91.4766C92.5761 84 93.5143 83.2055 93.6958 82.1212L95.2856 72.6212C95.5151 71.2495 94.4573 70 93.0663 70H54.0001V104.026C54.0001 113.968 62.0588 122.026 72.0001 122.026H86.0001V132.438C79.0733 135.069 73.1456 136 65.5076 136C46.0159 136 34.541 125.179 34.0001 106V70H3.84034C2.74109 70 1.80259 70.7945 1.62134 71.8788L0.0313423 81.3787C-0.197908 82.7505 0.859592 84 2.25059 84H20.0001V106C20.3073 118 23.4221 129.018 32.1076 137.773C40.0433 145.772 51.5928 150 65.5076 150C77.2311 150 86.1143 148.062 97.7051 142.642C99.1078 141.986 100 140.572 100 139.023V110.276C100 109.034 98.9928 108.026 97.7501 108.026Z"
                                  fill="#0085FF"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M6.93638 55.9999H34.0001V25.9599L54.0001 18.8777V55.9999H96.1599C97.2591 55.9999 98.1974 55.2054 98.3789 54.1212L99.9686 44.6212C100.198 43.2494 99.1404 41.9999 97.7494 41.9999H68.0001V2.25168C68.0001 0.69843 66.4634 -0.38757 64.9989 0.13093L21.4989 15.5349C20.6006 15.8532 20.0001 16.7029 20.0001 17.6559V41.9999H8.52613C7.42688 41.9999 6.48838 42.7944 6.30688 43.8787L4.71738 53.3787C4.48763 54.7504 5.54538 55.9999 6.93638 55.9999Z"
                                  fill="#0085FF"></path>
                        </svg>
                    <?php endif ?>
                </div>
                <div class="travelpayouts-deactivation__button travelpayouts-deactivation__button_close" data-action="close">&times;
                </div>
            </div>
            <div class="travelpayouts-deactivation__body">
                <div class="tp-preloader travelpayouts-deactivation__loader">
                    <div class="travelpayouts-deactivation__loader_image"></div>
                </div>
                <div id="travelpayouts-typeform" class="travelpayouts-deactivation__typeform"
                     data-id="<?= $isRU ? DeactivationFeedback::RU_FORM_ID : DeactivationFeedback::EN_FORM_ID ?>"></div>
            </div>
            <div class="travelpayouts-deactivation__footer travelpayouts-deactivation__footer--is-sticky">
                <span
                    class="travelpayouts-deactivation__button" data-action="deactivate"><?= Travelpayouts::__('Skip & Deactivate') ?></span>
            </div>
        </div>
    </div>
</div>
