<?php
/**
 * Created by: Andrey Polyakov (andrey@polyakov.im)
 */

namespace Travelpayouts\modules\tables\components\settings;

use Travelpayouts;
use Travelpayouts\components\section\fields\ImgSelect;
use Travelpayouts\components\section\fields\Select;

class ThemeSelectField extends ImgSelect
{
    protected $_themeList = [];

    public function init()
    {
        parent::init();
        $this->title = Travelpayouts::__('Themes');
    }

    public function setOptions($options): Select
    {
        $this->_themeList = $options;
        return parent::setOptions(self::themeImages($options)); // TODO: Change the autogenerated stub
    }

    public static function themeImages($themes): array
    {
        $themesWithImages = [];
        foreach ($themes as $key => $option) {
            $themesWithImages[$key] = [
                'alt' => $option,
                'img' => Travelpayouts::getAlias('@webImages') . '/' . 'admin/tables/flights/themes/' . $key . '.png',
            ];
        }

        return $themesWithImages;
    }

    public function result(): array
    {
        if (!empty($this->_themeList)) {
            $this->default = Travelpayouts\helpers\ArrayHelper::getFirst(array_keys($this->_themeList));
        }
        return parent::result();
    }
}