<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Popup Example</title>
        <style>
			/* Popup container styling */
				#popup-box {
				display: none; /* Initially hidden */
				position: fixed;
				top: 50%;
				left: 50%;
				transform: translate(-50%, -50%);
				background-color: white;
				padding: 20px;
				box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
				border-radius: 0px;
				z-index: 1000;

			}
			/* Overlay styling */
				#popup-overlay {
				display: none; /* Initially hidden */
				position: fixed;
				top: 0;
				left: 0;
				width: 100%;
				height: 100%;
				background-color: rgba(0, 0, 0, 0.5);
				z-index: 999;
			}
			/* Close button styling */
			.close-btn {
				background-color: #ff5e5700;
				color: white;
				border: none;
				padding: 2px 2px;
				border-radius: 5px;
				cursor: pointer;
				float: right;
				margin-top: -38px;
				margin-right: -37px;
			}

			.close-btn:hover {
				background-color: #f6f5f5;
    			border-radius: 20px;
			}
			.image-section img {
				max-width: 100%;
				height: auto;
				border-radius: 8px;
			}
			.text-section {
				text-align: center;
			}
			.text-section h1 {
				font-size: 1.5rem;
				margin: 0 0 10px;
				/* font-weight: bolder; */
			}
			.text-section p {
				margin: 0 0 30px;
				color: #555;
				line-height: 20px;
				/* font-weight: 500; */
				font-size: 17px;
			}
			.text-section a {
				display: inline-block;
				padding: 10px 20px;
				background-color: black;
				color: white;
				text-decoration: none;
				border-radius: 25px;
			}
			.text-section a:hover {
				background-color: #444;
			}
			#sgpb-popup-dialog-main-div {
				border-width: 0px!important;
				padding: 15px;
				margin-top: -20px;
			}
			#popup-box .image-section img {
				width: 100%;
				height: 325px;
				object-fit: cover;
				object-position: right;
			}
			#popup-box .image-section {
				float:left;
				width:50%;
			}
			#popup-box .text-section {
				float:left;
				width:50%;
			}
			#popup-box .text-section .text-box {
				padding: 20% 10%;
			}
			#popup-box .text-section .text-box .continue {
				background-color: #000;
				width: 110px;
				/* font-weight: bolder; */
				margin-right: 20px;
				float: left;
				margin-left: 7%;
				cursor: pointer;
			}
			#popup-box .text-section .text-box .skip {
				background-color: #ffffff;
				width: 110px;
				border: 1px solid #0a6eb5;
				color: #0a6eb5;
				float: left;
				cursor: pointer;
			}
			.sgpb-popup-overlay {
				background-color: rgb(97 96 96) !important;
			}
			.close-btn img{width: 30px;}
			.box-center{display: flex;justify-content: center;}
			@media screen and (min-width:320px) and (max-width:480px) {
				#popup-box .image-section {
				float:auto;
				width:100%;
				}
				#popup-box .text-section {
				float:auto;
				width:100%;
				}
				#popup-box .text-section .text-box {
				padding: 5% 5%;
				}
				#popup-box .image-section img {
				width: auto;
				height: 160px;
				margin: 0 auto;
				display: block;
				}
				#popup-box {
					display: none;
					position: fixed;
					top: 15%;
					left: 81%;
					transform: translate(-85%, -3%);
					background-color: white;
					padding: 20px 5px;
					box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
					border-radius: 0px;
					z-index: 1000;
					width: 85%;
				}
				.close-btn {
					background-color: #ff5e5700;
					color: white;
					border: none;
					padding: 2px 2px;
					border-radius: 5px;
					cursor: pointer;
					float: right;
					margin-top: -36px;
					margin-right: -22px;
				}
				#popup-box .text-section .text-box .continue {
					background-color: #000;
					width: 110px;
					font-weight: bolder;
					margin-right: 20px;
					float: left;
					margin-left: 7%;
				}
				#popup-box .text-section .text-box .skip {
					background-color: #ffffff;
					width: 110px;
					border: 1px solid #0a6eb5;
					color: #0a6eb5;
					float: left;
				}
			}
        </style>
    </head>
    <body>
        <!-- Overlay -->
        <div id="popup-overlay"></div>
        <!-- Popup Box -->
        <div id="popup-box">
            <button class="close-btn" onclick="openLinkAndClosePopup('<?= $updated_link ?>')">
                <img src="https://top10-comparison.com/wp-content/uploads/2024/12/cross-btn.png" alt="close">
            </button>
            <div class="container">
                <div class="image-section">
                    <img src="<?=$img?>" loading="lazy" alt="Solo Stove" style="cursor:pointer;" onclick="openLinkAndClosePopup('<?= $updated_link ?>')">
                </div>
                <div class="text-section">
                    <div class="text-box">
                        <h1>Our Top Picks
                            <br>
                            Just for You
                        </h1>
                        <p>We've handpicked top hotels from travel destinations to simplify your experience.</p>
                        <div class="box-center">
                            <a onclick="openLinkAndClosePopup('<?= $updated_link ?>')" class="continue">Continue</a>
                            <a onclick="openLinkAndClosePopup('<?= $updated_link ?>')" class="skip">Skip</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script>
			// Show popup after 10 seconds
			setTimeout(() => {
			document.getElementById("popup-overlay").style.display = "block";
			document.getElementById("popup-box").style.display = "block";
			}, 30000);

			function closePopup() {
				document.getElementById("popup-overlay").style.display = "none";
				document.getElementById("popup-box").style.display = "none";
			}

			function openLinkAndClosePopup(url) {
				window.open(url, '_blank'); 
				closePopup(); 
			}

        </script>
    </body>
</html>
