<?php 
    include "header.php";
   include "databaseConnect.php";  
   $cczCount ='';  
   $totalCount='';
   $ccaCount='';
?>
<style>
    .switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 23px;
    }
    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 15px;
        width: 15px;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
    }
    input:checked + .slider {
        background-color: #0d6efd;
    }
    input:focus + .slider {
        box-shadow: 0 0 1px #0d6efd;
    }
    input:checked + .slider:before {
        transform: translateX(26px);
    }
    .slider.round {
        border-radius: 34px;
    }
    .slider.round:before {
        border-radius: 50%;
    }
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"><i class="nav-icon fas fa-tachometer-alt"></i> Dashboard</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">Home</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content" style = "min-height:454px;">
        <div class="container-fluid">
            <form method="post" id="addForm" enctype="multipart/form-data">
                <input type = "hidden" name="type" value="addForm" />
                <div class="row">
                    <div class="col-sm-6">
                        <label for="examplegoogleMapSlug">Page Slug</label>
                        <input type="text" class="form-control" id="examplegoogleMapSlug" name="addslugUrl" placeholder="Enter Slug" >
                    </div>
                    <div class="col-sm-6">
                        <label for="examplegooglePageHeading">Page Heading</label>
                        <input type="text" class="form-control" id="examplegooglePageHeading" name="addPageHeading" placeholder="Enter Page Heading" >
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputHotelName">Hotel Name</label>
                            <input type="text" class="form-control" id="exampleInputHotelName" name="addhotelName" placeholder="Enter Hotel Name">
                            <small class="text-danger error" id="errorHotelName"></small>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputLink">Link</label>
                            <input type="text" class="form-control" id="exampleInputLink" name="addhotelLink" placeholder="Enter Link">
                            <small class="text-danger error" id="errorLink"></small>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputRatingComment">Rating Comment</label>
                            <input type="text" class="form-control" id="exampleInputRatingComment" name="addRatingComment" placeholder="Enter Rating Comment">
                            <small class="text-danger error" id="errorRatingComment"></small>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputReviewNumber">Review Number</label>
                            <input type="text" class="form-control" id="exampleInputReviewNumber" name="addReviewNumber" placeholder="Enter Review Number">
                            <small class="text-danger error" id="errorReviewNumber"></small>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputPricing">Pricing (in $s) </label>
                            <input type="text" class="form-control" id="exampleInputPricing" name="addPricing" placeholder="Enter Pricing (in $s)">
                            <small class="text-danger error" id="errorPricing"></small>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputFreeCancellation">Free Cancellations</label><br>
                            <label class="switch">
                                <input type="checkbox" value="1" id="exampleInputFreeCancellation" name="addFreeCancellation" class="toggle-topCity-btn" ><span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputNoPre-payment">No Pre-payment</label><br>
                            <label class="switch">
                                <input type="checkbox" value="1" id="exampleInputNoPre-payment" name="addNoPre-payment" class="toggle-topCity-btn" ><span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputHotelAddress">Hotel Address</label>
                            <input type="text" class="form-control" id="exampleInputHotelAddress" name="addHotelAddress" placeholder="Enter Hotel Address">
                            <small class="text-danger error" id="errorHotelAddress"></small>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group" bis_skin_checked="1">
                            <label for="exampleInputImageURL">Hotel Image Url</label>
                            <input type="text" class="form-control" id="exampleInputImageURL" name="addImageURL" placeholder="Enter Hotel Iamge URL">
                            <small class="text-danger error" id="errorImageURL"></small>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-6">
                        <label for="examplegoogleMapURl">Hotel Location Url</label>
                        <input type="text" class="form-control" id="examplegoogleMapURl" name="googleMapURL" placeholder="Enter Hotel Location Link">
                    </div>
                    <div class="col-sm-6">
                        <label for="image">Page Heading Image</label><br>
                        <input type="file" name="addPageImageURL" id="image" accept="image/*">
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-12">
                        <label>Amenities</label>
                        <textarea class="form-control" rows="3" name="hotelAmenities" placeholder="Enter Amenities..."></textarea>
                        <small class="text-danger error" id="errorAmenities"></small>
                    </div>
                </div>
                <div class="row text-right mb-3" style="justify-content:right;">
                    <button type="button" class="btn btn-primary btn-lg" id="addHotelData" onclick="addData();">Submit</button>
                </div>
            </form>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
<?php include "footer.php"?>
<script>
    function addData() {
        let isValid = true;
        $('.error').text('');
        const fields = [
            { id: "#exampleInputHotelName", errorId: "#errorHotelName", message: "Hotel name is required" },
            { id: "#exampleInputLink", errorId: "#errorLink", message: "Link is required" },
            { id: "#exampleInputRatingComment", errorId: "#errorRatingComment", message: "Rating comment is required" },
            { id: "#exampleInputReviewNumber", errorId: "#errorReviewNumber", message: "Review number is required" },
            { id: "#exampleInputPricing", errorId: "#errorPricing", message: "Pricing is required" },
            { id: "#exampleInputHotelAddress", errorId: "#errorHotelAddress", message: "Hotel address is required" },
            { id: "#exampleInputImageURL", errorId: "#errorImageURL", message: "Hotel image URL is required" },
            { id: "[name='hotelAmenities']", errorId: "#errorAmenities", message: "Amenities are required" }
        ];

        fields.forEach(field => {
            if ($(field.id).val().trim() === "") {
                $(field.errorId).text(field.message);
                isValid = false;
            }
        });
        if (isValid) {
            let formElement = $('#addForm')[0];
            let formData = new FormData(formElement);

            $.ajax({
                url: "manage-hotels-process.php",
                type: "POST",
                data: formData,
                processData: false, 
                contentType: false, 
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        toastr.success("Hotel added successfully");
                        $('#addForm')[0].reset();
                    } else {
                        toastr.error("Failed to add hotel: " + response.message);
                    }
                },
                error: function() {
                    toastr.error("An error occurred. Please try again.");
                }
            });
        }
    }
    $(document).ready(function() {
        $('#exampleInputPricing').on('keydown', function(e) {
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 37, 38, 39, 40]) !== -1 || 
                (e.keyCode >= 48 && e.keyCode <= 57) || 
                (e.keyCode >= 96 && e.keyCode <= 105)) {
                return true;
            }
            e.preventDefault();
            return false;
        });
    });

    $('#exampleInputReviewNumber').on('keydown', function(e) {
    if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 37, 38, 39, 40]) !== -1) {
        return true;
    }
    if ((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 96 && e.keyCode <= 105)) {
        return true;
    }
    if ((e.keyCode === 110 || e.keyCode === 190)) {
        if ($(this).val().indexOf('.') !== -1) {
            e.preventDefault();
            return false;
        }
        return true;
    }
    e.preventDefault();
    return false;
});



</script>