<?php
/** Don't load directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Foxiz_Register_Metaboxes', false ) ) {
	/**
	 * Class FOXIZ_CORE
	 * load plugin
	 */
	class Foxiz_Register_Metaboxes {

		private static $instance;

		public static function get_instance() {

			if ( self::$instance === null ) {
				return new self();
			}

			return self::$instance;
		}

		public function __construct() {

			self::$instance = $this;

			add_filter( 'rb_meta_boxes', array( $this, 'register' ) );
		}

		function register( $metaboxes = array() ) {

			$metaboxes[] = $this->single_post_metaboxes();
			$metaboxes[] = $this->page_metaboxes();

			return $metaboxes;
		}

		public function page_metaboxes() {

			return array(
				'id'         => 'foxiz_page_settings',
				'title'      => esc_html__( 'Single Page Settings', 'foxiz' ),
				'desc'       => esc_html__( 'The settings below will apply to the single page and Elementor pages. To config for the blog index page. Navigate to Theme Options > Blog & Archives > Blog Index', 'foxiz' ),
				'context'    => 'normal',
				'post_types' => array( 'page' ),
				'tabs'       => array(
					array(
						'id'     => 'section-page-general',
						'title'  => esc_html__( 'General', 'foxiz' ),
						'desc'   => esc_html__( 'Navigate to "Theme Options > Blog & Archives > Blog Index" to set layout and styles if you assign this page as the blog (index) page.', 'foxiz' ),
						'icon'   => 'dashicons-align-full-width',
						'fields' => array(
							array(
								'id'      => 'page_header_style',
								'name'    => esc_html__( 'Page Header Style', 'foxiz' ),
								'desc'    => esc_html__( 'Select a top header style for this page. This option is used for the single page (not Elementor page).', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Style 1', 'foxiz' ),
									'2'       => esc_html__( 'Style 2', 'foxiz' ),
									'3'       => esc_html__( 'Style 3', 'foxiz' ),
									'4'       => esc_html__( 'Style 4 (Require featured image)', 'foxiz' ),
									'-1'      => esc_html__( 'No Header', 'foxiz' )
								),
								'default' => 'default'
							),
							array(
								'id'      => 'page_header_width',
								'name'    => esc_html__( 'Max Width of Page Title', 'foxiz' ),
								'desc'    => esc_html__( 'Select a max-width (edge padding included) for the page title.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'small'   => esc_html__( 'Small - 860px', 'foxiz' ),
									'-1'      => esc_html__( 'Full Width - 1280px', 'foxiz' )
								),
								'default' => 'default'
							)
						)
					),
					array(
						'id'     => 'section-sidebar',
						'title'  => esc_html__( 'Sidebar Area', 'foxiz' ),
						'desc'   => esc_html__( 'The settings below will take priority over other settings in "Theme Options > Single Pages > Sidebar Area".', 'foxiz' ),
						'icon'   => 'dashicons-align-pull-right',
						'fields' => array(
							array(
								'id'      => 'sidebar_position',
								'name'    => esc_html__( 'Sidebar Position', 'foxiz' ),
								'desc'    => esc_html__( 'Select a position for this page sidebar.', 'foxiz' ),
								'class'   => 'sidebar-select',
								'type'    => 'image_select',
								'options' => foxiz_config_sidebar_position( true, true ),
								'default' => 'default'
							),
							array(
								'id'      => 'sidebar_name',
								'name'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
								'desc'    => esc_html__( 'Assign a custom sidebar for this page.', 'foxiz' ),
								'type'    => 'select',
								'options' => foxiz_config_sidebar_name(),
								'default' => 'default'
							),
							array(
								'id'      => 'width_wo_sb',
								'name'    => esc_html__( 'Max Width Content without Sidebar', 'foxiz' ),
								'desc'    => esc_html__( 'Select a max-width (edge padding included) for the content area without sidebar.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'small'   => esc_html__( 'Small - 860px', 'foxiz' ),
									'-1'      => esc_html__( 'Full Width - 1280px', 'foxiz' )
								),
								'default' => 'default'
							),
						)
					),
					array(
						'id'     => 'section-toc',
						'title'  => esc_html__( 'Table of Content', 'foxiz' ),
						'icon'   => 'dashicons-editor-ol',
						'fields' => array(
							array(
								'id'      => 'table_contents_page',
								'name'    => esc_html__( 'Table of Contents', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable the table content for this page.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),
							array(
								'id'      => 'table_contents_layout',
								'name'    => esc_html__( 'layout', 'foxiz' ),
								'desc'    => esc_html__( 'Select a layout for the table of contents of this page.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Full Width (2 Columns)', 'foxiz' ),
									'2'       => esc_html__( 'Half Width', 'foxiz' ),
									'3'       => esc_html__( 'Full Width (1 Column)', 'foxiz' ),
								),
								'default' => 'default'
							),
							array(
								'id'      => 'table_contents_position',
								'type'    => 'text',
								'name'    => esc_html__( 'Display Position', 'foxiz' ),
								'desc'    => esc_html__( 'Input a position (after x paragraphs) to display the table of contents box.', 'foxiz' ),
								'info'    => esc_html__( 'Leave blank as default, Set "-1" to display at the top.', 'foxiz' ),
								'default' => ''
							),
						),
					),
					array(
						'id'     => 'section-header',
						'title'  => esc_html__( 'Site Header', 'foxiz' ),
						'icon'   => 'dashicons-heading',
						'desc'   => esc_html__( 'The transparent headers are only suited for pages have a slider or wide background image at the top.', 'foxiz' ),
						'fields' => array(
							array(
								'id'      => 'header_style',
								'name'    => esc_html__( 'Site Header', 'foxiz' ),
								'desc'    => esc_html__( 'Select a site header for this page.', 'foxiz' ),
								'type'    => 'select',
								'options' => foxiz_config_header_style( true, true, false, true ),
								'default' => '0'
							),
							array(
								'id'      => 'nav_style',
								'type'    => 'select',
								'name'    => esc_html__( 'Navigation Bar Style', 'foxiz' ),
								'desc'    => esc_html__( 'Select navigation bar style for the site header of this page.', 'foxiz' ),
								'info'    => esc_html__( 'This setting will only apply to pre-defined headers: 1, 2, 3 and 5.', 'foxiz' ),
								'options' => array(
									'default'  => esc_html__( '- Default -', 'foxiz' ),
									'shadow'   => esc_html__( 'Shadow', 'foxiz' ),
									'border'   => esc_html__( 'Bottom Border', 'foxiz' ),
									'd-border' => esc_html__( 'Dark Bottom Border', 'foxiz' ),
									'none'     => esc_html__( 'None', 'foxiz' )
								),
								'default' => 'default'
							),
							array(
								'id'          => 'header_template',
								'name'        => esc_html__( 'Header Template Shortcode', 'foxiz' ),
								'desc'        => esc_html__( 'Input a Ruby Template shortcode for displaying as the site header for this page.', 'foxiz' ),
								'info'        => esc_html__( 'This setting will override on the "Header style" setting', 'foxiz' ),
								'type'        => 'textarea',
								'placeholder' => '[Ruby_E_Template id="1"]',
								'default'     => ''
							),
							array(
								'id'      => 'alert_bar',
								'name'    => esc_html__( 'Header Alert Bar', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable the alert bar below the header.', 'foxiz' ),
								'info'    => esc_html__( 'This setting will only apply to pre-defined header styles.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( 'Default', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),
							array(
								'id'      => 'disable_top_ad',
								'name'    => esc_html__( 'Top Site Advert', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable the top ad site for this page.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( 'Default', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),

						)
					),
					array(
						'id'     => 'section-footer',
						'title'  => esc_html__( 'Site Footer', 'foxiz' ),
						'icon'   => 'dashicons-align-full-width',
						'fields' => array(
							array(
								'id'          => 'footer_template',
								'name'        => esc_html__( 'Footer Template Shortcode', 'foxiz' ),
								'desc'        => esc_html__( 'Input a Ruby Template shortcode for displaying as the website footer for this page.', 'foxiz' ),
								'info'        => esc_html__( 'Leave blank as default.', 'foxiz' ),
								'placeholder' => '[Ruby_E_Template id="1"]',
								'type'        => 'textarea',
								'default'     => ''
							)
						)
					)
				)
			);
		}

		public function single_post_metaboxes() {

			return array(
				'id'         => 'foxiz_post_options',
				'title'      => esc_html__( 'Single Post Settings', 'foxiz' ),
				'context'    => 'normal',
				'post_types' => array( 'post' ),
				'tabs'       => array(
					array(
						'id'     => 'section-tagline',
						'title'  => esc_html__( 'Tagline & Highlights', 'foxiz' ),
						'icon'   => 'dashicons-edit-large',
						'fields' => array(
							array(
								'id'      => 'tagline',
								'name'    => esc_html__( 'Tagline', 'foxiz' ),
								'desc'    => esc_html__( 'Input a tagline for this post.', 'foxiz' ),
								'info'    => esc_html__( 'It will display under the single post title.', 'foxiz' ),
								'type'    => 'textarea',
								'default' => ''
							),
							array(
								'id'      => 'tagline_tag',
								'name'    => esc_html__( 'Tagline HTML Tag', 'foxiz' ),
								'desc'    => esc_html__( 'Select a HTML tag for this tagline.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'0'    => esc_html__( '- Default -', 'foxiz' ),
									'h2'   => esc_html__( 'H2', 'foxiz' ),
									'h3'   => esc_html__( 'H3', 'foxiz' ),
									'h4'   => esc_html__( 'H4', 'foxiz' ),
									'h5'   => esc_html__( 'H5', 'foxiz' ),
									'h6'   => esc_html__( 'H6', 'foxiz' ),
									'p'    => esc_html__( 'p', 'foxiz' ),
									'span' => esc_html__( 'span', 'foxiz' )
								),
								'default' => '0'
							),
							array(
								'id'     => 'highlights',
								'name'   => esc_html__( 'Post Highlights', 'foxiz' ),
								'desc'   => esc_html__( 'Show a highlights section at the top for the post content.', 'foxiz' ),
								'info'   => esc_html__( 'Navigate to "Theme Options > Single Post > Tagline & highlights" to edit the heading.', 'foxiz' ),
								'type'   => 'group',
								'button' => esc_html__( '+Add Highlight', 'foxiz' ),
								'fields' => array(
									array(
										'id'      => 'point',
										'name'    => esc_html__( 'Highlight Point', 'foxiz' ),
										'default' => '',
									),
								)
							),
						)
					),
					array(
						'id'     => 'section-featured',
						'title'  => esc_html__( 'Featured Image', 'foxiz' ),
						'icon'   => 'dashicons-format-image',
						'fields' => array(
							array(
								'id'      => 'featured_crop_size',
								'name'    => esc_html__( 'Featured Crop Size', 'foxiz' ),
								'desc'    => esc_html__( 'Select a custom crop size for this post featured image.', 'foxiz' ),
								'info'    => esc_html__( 'You can create new sizes in "Theme Options > Theme Design > Featured Image"', 'foxiz' ),
								'type'    => 'select',
								'options' => foxiz_config_crop_size(),
								'default' => 'default'
							),
							array(
								'id'      => 'featured_caption',
								'name'    => esc_html__( 'Caption Text', 'foxiz' ),
								'desc'    => esc_html__( 'Input caption text for the featured image.', 'foxiz' ),
								'type'    => 'textarea',
								'default' => ''
							),
							array(
								'id'      => 'featured_attribution',
								'name'    => esc_html__( 'Attribution', 'foxiz' ),
								'desc'    => esc_html__( 'Input an attribution for the featured image.', 'foxiz' ),
								'type'    => 'text',
								'default' => ''
							)
						)
					),
					array(
						'id'     => 'section-category',
						'title'  => esc_html__( 'Primary Category', 'foxiz' ),
						'desc'   => esc_html__( 'Only the selected category will show on the post listing.', 'foxiz' ),
						'icon'   => 'dashicons-admin-network',
						'fields' => array(
							array(
								'name'        => esc_html__( 'Primary Category', 'foxiz' ),
								'id'          => 'primary_category',
								'type'        => 'category_select',
								'taxonomy'    => 'category',
								'placeholder' => esc_html__( 'Select a primary category for this post.', 'foxiz' ),
								'desc'        => esc_html__( 'It is useful if this post has many categories.', 'foxiz' ),
								'info'        => esc_html__( 'Ensure the selected item belongs categories of this post.', 'foxiz' ),
								'default'     => ''
							),
						)
					),
					array(
						'id'     => 'section-custom-meta',
						'title'  => esc_html__( 'Custom Meta', 'foxiz' ),
						'desc'   => esc_html__( 'Navigate to "Theme Options > Styles & Design > Custom Meta" for more settings.', 'foxiz' ),
						'icon'   => 'dashicons-plus-alt',
						'fields' => array(
							array(
								'id'      => 'meta_custom',
								'name'    => esc_html__( 'Custom Meta Value', 'foxiz' ),
								'desc'    => esc_html__( 'Input a value for the custom meta that you created.', 'foxiz' ),
								'type'    => 'text',
								'default' => ''
							),
						)
					),
					array(
						'id'     => 'section-standard',
						'title'  => esc_html__( 'Standard Format', 'foxiz' ),
						'icon'   => 'dashicons-menu-alt',
						'desc'   => esc_html__( 'The setting below will apply to the standard post format.', 'foxiz' ),
						'fields' => array(
							array(
								'id'      => 'layout',
								'name'    => esc_html__( 'Standard Layout', 'foxiz' ),
								'desc'    => esc_html__( 'Select a layout for this post.', 'foxiz' ),
								'info'    => esc_html__( 'This setting will override on the Theme Option setting.', 'foxiz' ),
								'type'    => 'image_select',
								'class'   => 'big',
								'options' => foxiz_config_single_standard_layouts(),
								'default' => 'default'
							),
						)
					),
					array(
						'id'     => 'section-video',
						'title'  => esc_html__( 'Video Format', 'foxiz' ),
						'icon'   => 'dashicons-format-video',
						'desc'   => esc_html__( 'Select "Video" in the Post Format setting in the right pane to work.', 'foxiz' ),
						'fields' => array(
							array(
								'id'          => 'video_url',
								'name'        => esc_html__( 'Video URL', 'foxiz' ),
								'desc'        => esc_html__( 'Input your video link, support: Youtube, Vimeo, DailyMotion.', 'foxiz' ),
								'info'        => esc_html__( 'Do not forget to select "Video" from the "Post Format" dropdown.', 'foxiz' ),
								'placeholder' => 'https://youtu.be/...',
								'type'        => 'text',
								'default'     => ''
							),
							array(
								'id'          => 'video_embed',
								'name'        => esc_html__( 'Iframe Embed Code', 'foxiz' ),
								'desc'        => esc_html__( 'Input iframe embed code if WordPress cannot support your video URL.', 'foxiz' ),
								'info'        => esc_html__( 'Leave the "Video URL" setting blank to make it work.', 'foxiz' ),
								'placeholder' => '<iframe.....',
								'type'        => 'textarea'
							),
							array(
								'id'   => 'video_hosted',
								'name' => esc_html__( 'Self-Hosted Video', 'foxiz' ),
								'desc' => esc_html__( 'Upload your video file, support: mp4, m4v, webm, ogv, wmv, flv files.', 'foxiz' ),
								'info' => esc_html__( 'This setting will take priority over other video source settings.', 'foxiz' ),
								'type' => 'file'
							),
							array(
								'id'   => 'video_preview',
								'name' => esc_html__( 'Preview Video', 'foxiz' ),
								'desc' => esc_html__( 'Upload a preview video for displaying in the blog listing when hovering on featured image.', 'foxiz' ),
								'info' => esc_html__( 'Tips: Keep this preview video shorts and lightweight as possible.', 'foxiz' ),
								'type' => 'file'
							),
							array(
								'id'      => 'video_layout',
								'name'    => esc_html__( 'Video Layout', 'foxiz' ),
								'desc'    => esc_html__( 'Select a layout for this video post.', 'foxiz' ),
								'info'    => esc_html__( 'This setting will override on the Theme Option setting.', 'foxiz' ),
								'type'    => 'image_select',
								'class'   => 'big',
								'options' => foxiz_config_single_video_layouts(),
								'default' => 'default'
							),
							array(
								'id'      => 'video_autoplay',
								'name'    => esc_html__( 'Autoplay Video', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable autoplay video for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),
						)
					),
					/** post audio */
					array(
						'id'     => 'section-audio',
						'title'  => esc_html__( 'Audio Format', 'foxiz' ),
						'icon'   => 'dashicons-format-audio',
						'desc'   => esc_html__( 'Select "Audio" in the Post Format setting in the right pane to work.', 'foxiz' ),
						'fields' => array(
							array(
								'id'          => 'audio_url',
								'name'        => esc_html__( 'Audio URL', 'foxiz' ),
								'desc'        => esc_html__( 'Input your audio URL, support: SoundCloud, MixCloud.', 'foxiz' ),
								'info'        => esc_html__( 'Do not forget to select "Audio" from the "Post Format" dropdown.', 'foxiz' ),
								'placeholder' => 'https://soundcloud...',
								'type'        => 'text'
							),
							array(
								'id'          => 'audio_embed',
								'name'        => esc_html__( 'or Embed Code', 'foxiz' ),
								'desc'        => esc_html__( 'Input iframe embed code if WordPress cannot support your audio URL.', 'foxiz' ),
								'info'        => esc_html__( 'Leave the "Audio URL" setting blank to make it work.', 'foxiz' ),
								'placeholder' => '<iframe.....',
								'type'        => 'textarea'
							),
							array(
								'id'   => 'audio_hosted',
								'name' => esc_html__( 'Self-Hosted Audio', 'foxiz' ),
								'desc' => esc_html__( 'Upload your audio file, support: mp3, ogg, wma, m4a, wav files.', 'foxiz' ),
								'info' => esc_html__( 'This setting will take priority over other audio source settings.', 'foxiz' ),
								'type' => 'file'
							),
							array(
								'id'      => 'audio_layout',
								'name'    => esc_html__( 'Audio Layout', 'foxiz' ),
								'desc'    => esc_html__( 'Select a audio layout for this post.', 'foxiz' ),
								'info'    => esc_html__( 'This setting will override on the Theme Option setting.', 'foxiz' ),
								'type'    => 'image_select',
								'class'   => 'big',
								'options' => foxiz_config_single_audio_layouts(),
								'default' => 'default'
							),
							array(
								'id'      => 'audio_autoplay',
								'name'    => esc_html__( 'Autoplay Audio', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable autoplay audio for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),
						)
					),
					array(
						'id'     => 'section-gallery',
						'title'  => esc_html__( 'Gallery Format', 'foxiz' ),
						'icon'   => 'dashicons-format-gallery',
						'desc'   => esc_html__( 'Select "Gallery" in the Post Format setting in the right pane to work.', 'foxiz' ),
						'fields' => array(
							array(
								'id'      => 'gallery_data',
								'name'    => esc_html__( 'Upload Gallery', 'foxiz' ),
								'desc'    => esc_html__( 'Upload your images for this gallery.', 'foxiz' ),
								'info'    => esc_html__( 'Do not forget to select "Gallery" from the "Post Format" dropdown.', 'foxiz' ),
								'type'    => 'images',
								'default' => ''
							),
							array(
								'id'      => 'gallery_layout',
								'name'    => esc_html__( 'Gallery Layout', 'foxiz' ),
								'desc'    => esc_html__( 'Select a layout for this gallery post.', 'foxiz' ),
								'info'    => esc_html__( 'This setting will override on the Theme Option setting.', 'foxiz' ),
								'type'    => 'image_select',
								'class'   => 'big',
								'options' => foxiz_config_single_gallery_layouts(),
								'default' => 'default'
							),
						)
					),
					array(
						'id'     => 'section-sidebar',
						'title'  => esc_html__( 'Sidebar Area', 'foxiz' ),
						'desc'   => esc_html__( 'The settings below will take priority over other settings in "Theme Options > Single Post > Sidebar Area".', 'foxiz' ),
						'icon'   => 'dashicons-align-pull-right',
						'fields' => array(
							array(
								'id'      => 'sidebar_position',
								'name'    => esc_html__( 'Sidebar Position', 'foxiz' ),
								'desc'    => esc_html__( 'Select a position for this post sidebar.', 'foxiz' ),
								'class'   => 'sidebar-select',
								'type'    => 'image_select',
								'options' => foxiz_config_sidebar_position(),
								'default' => 'default'
							),
							array(
								'id'      => 'sidebar_name',
								'name'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
								'desc'    => esc_html__( 'Assign a custom sidebar for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => foxiz_config_sidebar_name(),
								'default' => 'default'
							),
						)
					),
					array(
						'id'     => 'section-review',
						'title'  => esc_html__( 'Review', 'foxiz' ),
						'icon'   => 'dashicons-star-filled',
						'desc'   => esc_html__( 'As default, The box will appear at the bottom. Use [ruby_review_box] shortcode if you want to put the box anywhere in the post content.', 'foxiz' ),
						'fields' => array(
							array(
								'id'      => 'review',
								'name'    => esc_html__( 'Post Review', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable the review box.', 'foxiz' ),
								'type'    => 'select',
								'class'   => 'ruby-review-checkbox',
								'options' => array(
									'-1' => esc_html__( '- Disable -', 'foxiz' ),
									'1'  => esc_html__( 'Enable', 'foxiz' )
								),
								'default' => '-1'
							),
							array(
								'id'      => 'user_can_review',
								'name'    => esc_html__( 'User Rating in Comments', 'foxiz' ),
								'desc'    => esc_html__( 'Visitors can leave a rating and review for this post.', 'foxiz' ),
								'info'    => esc_html__( 'The comment box will be replaced with the review box.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' ),
									'1'       => esc_html__( 'Enable with Review', 'foxiz' ),
									'2'       => esc_html__( 'Force Enable for This Post', 'foxiz' ),
								),
								'default' => 'default'
							),
							array(
								'id'      => 'review_type',
								'name'    => esc_html__( 'Review Type', 'foxiz' ),
								'desc'    => esc_html__( 'Select a type of review for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'star'    => esc_html__( 'Stars (1 > 5)', 'foxiz' ),
									'score'   => esc_html__( 'Score (1 > 10)', 'foxiz' ),
								),
								'default' => 'default'
							),
							array(
								'id'      => 'review_title',
								'name'    => esc_html__( 'Review Heading', 'foxiz' ),
								'desc'    => esc_html__( 'Input a heading for this review box.', 'foxiz' ),
								'type'    => 'text',
								'default' => esc_html__( 'Review Overview', 'foxiz' )
							),
							array(
								'id'   => 'review_image',
								'name' => esc_html__( 'Header Background', 'foxiz' ),
								'desc' => esc_html__( 'Upload a background image for the header.', 'foxiz' ),
								'type' => 'file'
							),
							array(
								'id'     => 'review_criteria',
								'name'   => esc_html__( 'Criteria Data', 'foxiz' ),
								'desc'   => esc_html__( 'Create your review criteria based on the type you choose.', 'foxiz' ),
								'type'   => 'group',
								'button' => '+ Add Criteria',
								'fields' => array(
									array(
										'name'    => esc_html__( 'Item Label', 'foxiz' ),
										'id'      => 'label',
										'default' => esc_html__( 'Criteria', 'foxiz' ),
									),
									array(
										'name'    => esc_html__( 'Score (1 > 10) or Rating (1 > 5)', 'foxiz' ),
										'id'      => 'rating',
										'default' => '',
									)
								)
							),
							array(
								'id'     => 'review_pros',
								'name'   => esc_html__( 'Advantages', 'foxiz' ),
								'desc'   => esc_html__( 'Input advantages for this review.', 'foxiz' ),
								'type'   => 'group',
								'button' => '+ Add Pros',
								'fields' => array(
									array(
										'name'    => esc_html__( 'Item', 'foxiz' ),
										'id'      => 'pros_item',
										'default' => esc_html__( 'advantage item', 'foxiz' ),
									)
								)
							),
							array(
								'id'     => 'review_cons',
								'name'   => esc_html__( 'Disadvantages', 'foxiz' ),
								'desc'   => esc_html__( 'Input disadvantages for this review.', 'foxiz' ),
								'type'   => 'group',
								'button' => '+ Add Cons',
								'fields' => array(
									array(
										'name'    => esc_html__( 'Item', 'foxiz' ),
										'id'      => 'cons_item',
										'default' => esc_html__( 'disadvantage item', 'foxiz' ),
									)
								)
							),
							array(
								'id'   => 'review_meta',
								'name' => esc_html__( 'Meta Description', 'foxiz' ),
								'desc' => esc_html__( 'Input a short description to display before the review score, For example: Good, Bad...', 'foxiz' ),
								'type' => 'text'
							),
							array(
								'id'   => 'review_summary',
								'name' => esc_html__( 'Final Summary', 'foxiz' ),
								'desc' => esc_html__( 'Input final summary for this review.', 'foxiz' ),
								'type' => 'textarea'
							),
							array(
								'id'   => 'review_button',
								'name' => esc_html__( 'Offer Label', 'foxiz' ),
								'desc' => esc_html__( 'Input a offer label (Call to action) for this product review.', 'foxiz' ),
								'type' => 'text'
							),
							array(
								'id'   => 'review_destination',
								'name' => esc_html__( 'Offer Destination URL', 'foxiz' ),
								'desc' => esc_html__( 'Input the destination URL of the offer.', 'foxiz' ),
								'info' => esc_html__( 'Review schema will use this information.', 'foxiz' ),
								'type' => 'text'
							),
							array(
								'id'          => 'review_price',
								'name'        => esc_html__( 'Price Offer', 'foxiz' ),
								'desc'        => esc_html__( 'Input the price of the offer.', 'foxiz' ),
								'info'        => esc_html__( 'Review schema will use this information.', 'foxiz' ),
								'placeholder' => '99',
								'type'        => 'text'
							),
							array(
								'id'          => 'review_currency',
								'name'        => esc_html__( 'Currency', 'foxiz' ),
								'desc'        => esc_html__( 'Input a currency for the offer price.', 'foxiz' ),
								'info'        => esc_html__( 'Review schema will use this information.', 'foxiz' ),
								'placeholder' => 'USD',
								'type'        => 'text'
							),
							array(
								'id'          => 'review_price_valid',
								'name'        => esc_html__( 'Price Valid Until', 'foxiz' ),
								'desc'        => esc_html__( 'Input the valid until  date for this offer, Ensure you input right format: yyyy-mm-dd', 'foxiz' ),
								'info'        => esc_html__( 'Review schema will use this information.', 'foxiz' ),
								'placeholder' => esc_html__( 'yyyy-mm-dd', 'foxiz' ),
								'type'        => 'text'
							)
						)
					),
					array(
						'id'     => 'section-sponsor',
						'title'  => esc_html__( 'Sponsored Post', 'foxiz' ),
						'icon'   => 'dashicons-bell',
						'fields' => array(
							array(
								'id'      => 'sponsor_post',
								'name'    => esc_html__( 'Sponsored Post', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable sponsored content for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'-1' => esc_html__( '- Disable -', 'foxiz' ),
									'1'  => esc_html__( 'Enable', 'foxiz' )
								),
								'default' => '-1'
							),
							array(
								'id'      => 'sponsor_url',
								'name'    => esc_html__( 'Sponsor URL', 'foxiz' ),
								'desc'    => esc_html__( 'Input the sponsor website URL.', 'foxiz' ),
								'type'    => 'text',
								'default' => ''
							),
							array(
								'id'      => 'sponsor_name',
								'name'    => esc_html__( 'Sponsor Name', 'foxiz' ),
								'desc'    => esc_html__( 'Input the sponsor brand name for this post', 'foxiz' ),
								'type'    => 'text',
								'default' => ''
							),
							array(
								'id'   => 'sponsor_logo',
								'name' => esc_html__( 'Sponsor Logo', 'foxiz' ),
								'desc' => esc_html__( 'Upload the sponsor logo for this post.', 'foxiz' ),
								'info' => esc_html__( 'The recommended height value is 52px.', 'foxiz' ),
								'type' => 'file'
							),
							array(
								'id'   => 'sponsor_logo_light',
								'name' => esc_html__( 'Sponsor Light Logo', 'foxiz' ),
								'desc' => esc_html__( 'Upload the sponsor light logo for this post.', 'foxiz' ),
								'type' => 'file'
							),
							array(
								'id'      => 'sponsor_redirect',
								'name'    => esc_html__( 'Directly Redirect', 'foxiz' ),
								'desc'    => esc_html__( 'Directly redirect to the sponsor website when clicking on the post listing title.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' )
								),
								'default' => 'default'
							)
						)
					),
					array(
						'id'     => 'section-shares',
						'title'  => esc_html__( 'Fake Post Views', 'foxiz' ),
						'desc'   => esc_html__( 'The view meta requests the "Post Views Counter" plugin to run.', 'foxiz' ),
						'icon'   => 'dashicons-visibility',
						'fields' => array(
							array(
								'id'      => 'start_view',
								'name'    => esc_html__( 'Fake View Value', 'foxiz' ),
								'desc'    => esc_html__( 'Input a starting view value for this post.', 'foxiz' ),
								'info'    => esc_html__( 'Leave this setting blank to display the real count.', 'foxiz' ),
								'type'    => 'text',
								'default' => ''
							),
						)
					),
					array(
						'id'     => 'section-widget',
						'title'  => esc_html__( 'Content Widgets', 'foxiz' ),
						'desc'   => esc_html__( 'Top and bottom content sections to show advertise.', 'foxiz' ),
						'icon'   => 'dashicons-editor-insertmore',
						'fields' => array(
							array(
								'id'      => 'entry_top',
								'name'    => esc_html__( 'Top Widgets Area', 'foxiz' ),
								'desc'    => esc_html__( 'Show widgets at the top of the post content.', 'foxiz' ),
								'info'    => esc_html__( 'Navigate to "Appearance > Widgets > Single Content - Top Area" to add your widgets.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'1'  => esc_html__( 'Enable', 'foxiz' ),
									'-1' => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => '1'
							),
							array(
								'id'      => 'entry_bottom',
								'name'    => esc_html__( 'Bottom Widgets Area', 'foxiz' ),
								'desc'    => esc_html__( 'Show widgets at the bottom of the post content.', 'foxiz' ),
								'info'    => esc_html__( 'Navigate to "Appearance > Widgets > Single Content - Bottom Area" to add your widgets.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'1'  => esc_html__( 'Enable', 'foxiz' ),
									'-1' => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => '1'
							),
						)
					),
					array(
						'id'     => 'section-toc',
						'title'  => esc_html__( 'Table of Content', 'foxiz' ),
						'desc'   => esc_html__( 'The settings below will take priority over other settings in "Theme Options > Table of Content".', 'foxiz' ),
						'icon'   => 'dashicons-editor-ol',
						'fields' => array(
							array(
								'id'      => 'table_contents_post',
								'name'    => esc_html__( 'Table of Contents', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable the table content for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),
							array(
								'id'      => 'table_contents_layout',
								'name'    => esc_html__( 'layout', 'foxiz' ),
								'desc'    => esc_html__( 'Select a layout for the table of contents of this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Full Width (2 Columns)', 'foxiz' ),
									'2'       => esc_html__( 'Half Width', 'foxiz' ),
									'3'       => esc_html__( 'Full Width (1 Column)', 'foxiz' ),
								),
								'default' => 'default'
							),
							array(
								'id'      => 'table_contents_position',
								'type'    => 'text',
								'name'    => esc_html__( 'Display Position', 'foxiz' ),
								'desc'    => esc_html__( 'Input a position (after x paragraphs) to display the table of contents box.', 'foxiz' ),
								'info'    => esc_html__( 'Leave blank as default, Set "-1" to display at the top.', 'foxiz' ),
								'default' => ''
							),
						),
					),
					array(
						'id'     => 'section-pages-selected',
						'title'  => esc_html__( 'Break Page Selection', 'foxiz' ),
						'desc'   => esc_html__( 'Ensure all headings of the post content are added to work.', 'foxiz' ),
						'icon'   => 'dashicons-admin-page',
						'fields' => array(
							array(
								'id'     => 'page_selected',
								'name'   => esc_html__( 'Headings Table', 'foxiz' ),
								'desc'   => esc_html__( 'Display page selected section when you use break pages for a lengthy content post.', 'foxiz' ),
								'info'   => esc_html__( 'Input the heading for each page corresponding to the page break tags.', 'foxiz' ),
								'type'   => 'group',
								'button' => esc_html__( '+Add Heading', 'foxiz' ),
								'fields' => array(
									array(
										'id'      => 'title',
										'name'    => esc_html__( 'Input Heading', 'foxiz' ),
										'default' => '',
									),
								)
							),
						)
					),
					array(
						'id'     => 'section-via',
						'title'  => esc_html__( 'Sources/Via', 'foxiz' ),
						'icon'   => 'dashicons-paperclip',
						'fields' => array(
							array(
								'id'     => 'source_data',
								'name'   => esc_html__( 'Post Sources', 'foxiz' ),
								'desc'   => esc_html__( 'Add sources for this post.', 'foxiz' ),
								'info'   => esc_html__( 'It will display below the post tags.', 'foxiz' ),
								'type'   => 'group',
								'class'  => 'small-item',
								'button' => esc_html__( '+Add Post Source', 'foxiz' ),
								'fields' => array(
									array(
										'name'    => esc_html__( 'Source Name', 'foxiz' ),
										'id'      => 'name',
										'default' => '',
									),
									array(
										'name'    => esc_html__( 'Source URL', 'foxiz' ),
										'id'      => 'url',
										'default' => '',
									)

								)
							),
							array(
								'id'     => 'via_data',
								'name'   => esc_html__( 'Post Via', 'foxiz' ),
								'desc'   => esc_html__( 'Add via or credit for this post.', 'foxiz' ),
								'info'   => esc_html__( 'It will display below the post tags.', 'foxiz' ),
								'type'   => 'group',
								'class'  => 'small-item',
								'button' => esc_html__( '+Add Post Via', 'foxiz' ),
								'fields' => array(
									array(
										'name'    => esc_html__( 'Via Name', 'foxiz' ),
										'id'      => 'name',
										'default' => '',
									),
									array(
										'name'    => esc_html__( 'Via URL', 'foxiz' ),
										'id'      => 'url',
										'default' => '',
									)

								)
							)
						)
					),
					array(
						'id'     => 'section-ajax',
						'title'  => 'Auto Load Next Posts',
						'icon'   => 'dashicons-update',
						'fields' => array(
							array(
								'id'      => 'ajax_next_post',
								'name'    => esc_html__( 'Auto Load Next Posts', 'foxiz' ),
								'desc'    => esc_html__( 'Load next posts when scrolling down to the single bottom.', 'foxiz' ),
								'info'    => esc_html__( 'Navigate to "Theme Options > Single Post > Auto Load Next Posts" for more settings.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							)
						)
					),
					array(
						'id'     => 'section-reaction',
						'title'  => 'Reaction',
						'icon'   => 'dashicons-heart',
						'fields' => array(
							array(
								'id'      => 'reaction',
								'name'    => esc_html__( 'User Reaction', 'foxiz' ),
								'desc'    => esc_html__( 'Show the reaction section at the bottom of the post content.', 'foxiz' ),
								'info'    => esc_html__( 'Navigate to "Theme Options > User Reaction" for more settings.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							)
						)
					),
					array(
						'id'     => 'section-seo',
						'title'  => 'SEO Optimized',
						'desc'   => esc_html__( 'Disable default schema markup if you use a party 3rd SEO plugin.', 'foxiz' ),
						'icon'   => 'dashicons-chart-area',
						'fields' => array(
							array(
								'id'      => 'article_markup',
								'name'    => esc_html__( 'Article Schema Markup', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable the article markup for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),
							array(
								'id'      => 'review_markup',
								'name'    => esc_html__( 'Review Schema Markup', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable review markup for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( '- Default -', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
								),
								'default' => 'default'
							)
						)
					),
					array(
						'id'     => 'section-header',
						'title'  => 'Site Header',
						'icon'   => 'dashicons-heading',
						'desc'   => esc_html__( 'The transparent headers are only suited for layouts: Standard 2, Standard 5, Video 2 and Audio 2.', 'foxiz' ),
						'fields' => array(
							array(
								'id'      => 'header_style',
								'name'    => esc_html__( 'Header Style', 'foxiz' ),
								'desc'    => esc_html__( 'Select a site header for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => foxiz_config_header_style( true, true ),
								'default' => 'default'
							),
							array(
								'id'      => 'nav_style',
								'type'    => 'select',
								'name'    => esc_html__( 'Navigation Bar Style', 'foxiz' ),
								'desc'    => esc_html__( 'Select navigation bar style for the site header of this post.', 'foxiz' ),
								'info'    => esc_html__( 'This setting will only apply to pre-defined headers: 1, 2, 3 and 5.', 'foxiz' ),
								'options' => array(
									'default'  => esc_html__( '- Default -', 'foxiz' ),
									'shadow'   => esc_html__( 'Shadow', 'foxiz' ),
									'border'   => esc_html__( 'Bottom Border', 'foxiz' ),
									'd-border' => esc_html__( 'Dark Bottom Border', 'foxiz' ),
									'none'     => esc_html__( 'None', 'foxiz' )
								),
								'default' => 'default'
							),
							array(
								'id'          => 'header_template',
								'name'        => esc_html__( 'Template Shortcode', 'foxiz' ),
								'desc'        => esc_html__( 'Input a Ruby Template shortcode for displaying as the website header for this page.', 'foxiz' ),
								'info'        => esc_html__( 'This setting will override on the "Header style" setting.', 'foxiz' ),
								'placeholder' => '[Ruby_E_Template id="1"]',
								'type'        => 'textarea',
								'default'     => ''
							),
							array(
								'id'      => 'alert_bar',
								'name'    => esc_html__( 'Header Alert Bar', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable the alert bar below the header.', 'foxiz' ),
								'info'    => esc_html__( 'This setting will only apply to pre-defined header styles.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( 'Default', 'foxiz' ),
									'1'       => esc_html__( 'Enable', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),
							array(
								'id'      => 'disable_top_ad',
								'name'    => esc_html__( 'Top Site Advert', 'foxiz' ),
								'desc'    => esc_html__( 'Enable or disable the top ad site for this post.', 'foxiz' ),
								'type'    => 'select',
								'options' => array(
									'default' => esc_html__( 'Default', 'foxiz' ),
									'-1'      => esc_html__( 'Disable', 'foxiz' )
								),
								'default' => 'default'
							),
						)
					),
					array(
						'id'     => 'section-footer',
						'title'  => esc_html__( 'Site Footer', 'foxiz' ),
						'icon'   => 'dashicons-align-full-width',
						'fields' => array(
							array(
								'id'          => 'footer_template',
								'name'        => esc_html__( 'Template Shortcode', 'foxiz' ),
								'desc'        => esc_html__( 'Input a Ruby Template shortcode for displaying as the website footer for this post.', 'foxiz' ),
								'info'        => esc_html__( 'Leave blank as default.', 'foxiz' ),
								'type'        => 'textarea',
								'placeholder' => '[Ruby_E_Template id="1"]',
								'default'     => ''
							)
						)
					)
				)
			);
		}
	}
}