<?php

namespace Google\Web_Stories_Dependencies\AmpProject\Html;

/**
 * Interface with constants for the different types of attributes.
 *
 * phpcs:disable Generic.Files.LineLength.TooLong
 *
 * @package ampproject/amp-toolbox
 */
interface Attribute
{
    const ABBR = 'abbr';
    const ABOUT = 'about';
    const ACCEPT = 'accept';
    const ACCEPT_CHARSET = 'accept-charset';
    const ACCESSKEY = 'accesskey';
    const ACCESS_HIDE = 'access-hide';
    const ACTION = 'action';
    const ACTION_XHR = 'action-xhr';
    const ADVANCE_COUNT = 'advance-count';
    const ALBUM = 'album';
    const ALIGN = 'align';
    const ALIGNMENT_BASELINE = 'alignment-baseline';
    const ALIGN_CONTENT = 'align-content';
    const ALIGN_ITEMS = 'align-items';
    const ALIGN_SELF = 'align-self';
    const ALL = 'all';
    const ALLOW = 'allow';
    const ALLOWFULLSCREEN = 'allowfullscreen';
    const ALLOWPAYMENTREQUEST = 'allowpaymentrequest';
    const ALLOWTRANSPARENCY = 'allowtransparency';
    const ALLOW_BLOCKED_END_DATE = 'allow-blocked-end-date';
    const ALLOW_BLOCKED_RANGES = 'allow-blocked-ranges';
    const ALLOW_SSR_IMG = 'allow-ssr-img';
    const ALPHA = 'alpha';
    const ALPHA_RANGE = 'alpha-range';
    const ALT = 'alt';
    const ALWAYS_SERVE_NPA = 'alwaysServeNpa';
    const AMP = 'amp';
    const AMP4ADS = 'amp4ads';
    const AMP4ADS_BOILERPLATE = 'amp4ads-boilerplate';
    const AMP4ADS_EMOJI = self::AMP_EMOJI . '4ads';
    const AMP4ADS_EMOJI_ALT = self::AMP_EMOJI_ALT . '4ads';
    const AMP4EMAIL = 'amp4email';
    const AMP4EMAIL_BOILERPLATE = 'amp4email-boilerplate';
    const AMP4EMAIL_EMOJI = self::AMP_EMOJI . '4email';
    const AMP4EMAIL_EMOJI_ALT = self::AMP_EMOJI_ALT . '4email';
    const AMPLITUDE = 'amplitude';
    const AMP_ACCESS = 'amp-access';
    const AMP_ACCESS_BEHAVIOR = 'amp-access-behavior';
    const AMP_ACCESS_HIDE = 'amp-access-hide';
    const AMP_ACCESS_ID = 'amp-access-id';
    const AMP_ACCESS_LOADER = 'amp-access-loader';
    const AMP_ACCESS_LOADING = 'amp-access-loading';
    const AMP_ACCESS_OFF = 'amp-access-off';
    const AMP_ACCESS_ON = 'amp-access-on';
    const AMP_ACCESS_SHOW = 'amp-access-show';
    const AMP_ACCESS_STYLE = 'amp-access-style';
    const AMP_ACCESS_TEMPLATE = 'amp-access-template';
    const AMP_BOILERPLATE = 'amp-boilerplate';
    const AMP_CUSTOM = 'amp-custom';
    const AMP_CUSTOM_LENGTH_CHECK = 'amp-custom-length-check';
    const AMP_EMOJI = "⚡";
    const AMP_EMOJI_ALT = "⚡️";
    // See https://github.com/ampproject/amphtml/issues/25990.
    const AMP_EXTENSION = 'amp-extension';
    const AMP_FX = 'amp-fx';
    const AMP_KEYFRAMES = 'amp-keyframes';
    const AMP_NESTED_SUBMENU = 'amp-nested-submenu';
    const AMP_NESTED_SUBMENU_CLOSE = 'amp-nested-submenu-close';
    const AMP_NESTED_SUBMENU_OPEN = 'amp-nested-submenu-open';
    const AMP_NOSCRIPT = 'amp-noscript';
    const AMP_ONERROR = 'amp-onerror';
    const AMP_RUNTIME = 'amp-runtime';
    const AMP_SCRIPT_SRC = 'amp-script-src';
    const AMP_STORY_DVH_POLYFILL = 'amp-story-dvh-polyfill';
    const ANCHOR = 'anchor';
    const ANIMATE = 'animate';
    const ANIMATE_IN = 'animate-in';
    const ANIMATE_IN_AFTER = 'animate-in-after';
    const ANIMATE_IN_DELAY = 'animate-in-delay';
    const ANIMATE_IN_DURATION = 'animate-in-duration';
    const ANIMATE_IN_TIMING_FUNCTION = 'animate-in-timing-function';
    const ANIMATION = 'animation';
    const ANIMATION_DELAY = 'animation-delay';
    const ANIMATION_DIRECTION = 'animation-direction';
    const ANIMATION_DURATION = 'animation-duration';
    const ANIMATION_FILL_MODE = 'animation-fill-mode';
    const ANIMATION_ITERATION_COUNT = 'animation-iteration-count';
    const ANIMATION_NAME = 'animation-name';
    const ANIMATION_PLAY_STATE = 'animation-play-state';
    const ANIMATION_TIMING_FUNCTION = 'animation-timing-function';
    const ANTIALIASING = 'antialiasing';
    const APPEARANCE = 'appearance';
    const ARABIC_FORM = 'arabic-form';
    const ARGUMENTS = 'arguments';
    const ARIA_ACTIVEDESCENDANT = 'aria-activedescendant';
    const ARIA_ATOMIC = 'aria-atomic';
    const ARIA_AUTOCOMPLETE = 'aria-autocomplete';
    const ARIA_BUSY = 'aria-busy';
    const ARIA_CHECKED = 'aria-checked';
    const ARIA_CONTROLS = 'aria-controls';
    const ARIA_CURRENT = 'aria-current';
    const ARIA_DESCRIBEDBY = 'aria-describedby';
    const ARIA_DISABLED = 'aria-disabled';
    const ARIA_DROPEFFECT = 'aria-dropeffect';
    const ARIA_EXPANDED = 'aria-expanded';
    const ARIA_FLOWTO = 'aria-flowto';
    const ARIA_GRABBED = 'aria-grabbed';
    const ARIA_HASPOPUP = 'aria-haspopup';
    const ARIA_HIDDEN = 'aria-hidden';
    const ARIA_INVALID = 'aria-invalid';
    const ARIA_LABEL = 'aria-label';
    const ARIA_LABELLEDBY = 'aria-labelledby';
    const ARIA_LEVEL = 'aria-level';
    const ARIA_LIVE = 'aria-live';
    const ARIA_MODAL = 'aria-modal';
    const ARIA_MULTILINE = 'aria-multiline';
    const ARIA_MULTISELECTABLE = 'aria-multiselectable';
    const ARIA_ORIENTATION = 'aria-orientation';
    const ARIA_OWNS = 'aria-owns';
    const ARIA_POSINSET = 'aria-posinset';
    const ARIA_PRESSED = 'aria-pressed';
    const ARIA_READONLY = 'aria-readonly';
    const ARIA_RELEVANT = 'aria-relevant';
    const ARIA_REQUIRED = 'aria-required';
    const ARIA_SELECTED = 'aria-selected';
    const ARIA_SETSIZE = 'aria-setsize';
    const ARIA_SORT = 'aria-sort';
    const ARIA_VALUEMAX = 'aria-valuemax';
    const ARIA_VALUEMIN = 'aria-valuemin';
    const ARIA_VALUENOW = 'aria-valuenow';
    const ARIA_VALUETEXT = 'aria-valuetext';
    const ARROWS = 'arrows';
    const ARTIST = 'artist';
    const ARTWORK = 'artwork';
    const ASPECT_RATIO = 'aspect-ratio';
    const ASPECT_RATIO_HEIGHT = 'aspect-ratio-height';
    const ASPECT_RATIO_WIDTH = 'aspect-ratio-width';
    const ASYNC = 'async';
    const AS_ = 'as';
    // Underscore needed because 'as' is a PHP keyword.
    const ATTRIBUTION = 'attribution';
    const ATTRIBUTIONDESTINATION = 'attributiondestination';
    const ATTRIBUTIONEXPIRY = 'attributionexpiry';
    const ATTRIBUTIONREPORTTO = 'attributionreportto';
    const ATTRIBUTIONSOURCEEVENTID = 'attributionsourceeventid';
    const ATTRIBUTIONSOURCEID = 'attributionsourceid';
    const AUTOCOMPLETE = 'autocomplete';
    const AUTOEXPAND = 'autoexpand';
    const AUTOFOCUS = 'autofocus';
    const AUTOPLAY = 'autoplay';
    const AUTOROTATE = 'autorotate';
    const AUTOSCROLL = 'autoscroll';
    const AUTO_ADVANCE = 'auto-advance';
    const AUTO_ADVANCE_AFTER = 'auto-advance-after';
    const AUTO_ADVANCE_COUNT = 'auto-advance-count';
    const AUTO_ADVANCE_INTERVAL = 'auto-advance-interval';
    const AUTO_ADVANCE_LOOPS = 'auto-advance-loops';
    const AUTO_RESIZE = 'auto-resize';
    const AZIMUTH = 'azimuth';
    const BACKFACE_VISIBILITY = 'backface-visibility';
    const BACKGROUND = 'background';
    const BACKGROUND_ATTACHMENT = 'background-attachment';
    const BACKGROUND_AUDIO = 'background-audio';
    const BACKGROUND_BLEND_MODE = 'background-blend-mode';
    const BACKGROUND_CLIP = 'background-clip';
    const BACKGROUND_COLOR = 'background-color';
    const BACKGROUND_IMAGE = 'background-image';
    const BACKGROUND_ORIGIN = 'background-origin';
    const BACKGROUND_POSITION = 'background-position';
    const BACKGROUND_REPEAT = 'background-repeat';
    const BACKGROUND_SIZE = 'background-size';
    const BASEFREQUENCY = 'basefrequency';
    const BASELINE_SHIFT = 'baseline-shift';
    const BETA_RANGE = 'beta-range';
    const BGCOLOR = 'bgcolor';
    const BIAS = 'bias';
    const BIGGEST_UNIT = 'biggest-unit';
    const BINDING = 'binding';
    const BLOCK_RTC = 'blockRtc';
    const BLOCKED = 'blocked';
    const BORDER = 'border';
    const BORDER_BOTTOM = 'border-bottom';
    const BORDER_BOTTOM_COLOR = 'border-bottom-color';
    const BORDER_BOTTOM_LEFT_RADIUS = 'border-bottom-left-radius';
    const BORDER_BOTTOM_RIGHT_RADIUS = 'border-bottom-right-radius';
    const BORDER_BOTTOM_STYLE = 'border-bottom-style';
    const BORDER_BOTTOM_WIDTH = 'border-bottom-width';
    const BORDER_COLLAPSE = 'border-collapse';
    const BORDER_COLOR = 'border-color';
    const BORDER_IMAGE = 'border-image';
    const BORDER_IMAGE_OUTSET = 'border-image-outset';
    const BORDER_IMAGE_REPEAT = 'border-image-repeat';
    const BORDER_IMAGE_SLICE = 'border-image-slice';
    const BORDER_IMAGE_SOURCE = 'border-image-source';
    const BORDER_IMAGE_WIDTH = 'border-image-width';
    const BORDER_LEFT = 'border-left';
    const BORDER_LEFT_COLOR = 'border-left-color';
    const BORDER_LEFT_STYLE = 'border-left-style';
    const BORDER_LEFT_WIDTH = 'border-left-width';
    const BORDER_RADIUS = 'border-radius';
    const BORDER_RIGHT = 'border-right';
    const BORDER_RIGHT_COLOR = 'border-right-color';
    const BORDER_RIGHT_STYLE = 'border-right-style';
    const BORDER_RIGHT_WIDTH = 'border-right-width';
    const BORDER_SPACING = 'border-spacing';
    const BORDER_STYLE = 'border-style';
    const BORDER_TOP = 'border-top';
    const BORDER_TOP_COLOR = 'border-top-color';
    const BORDER_TOP_LEFT_RADIUS = 'border-top-left-radius';
    const BORDER_TOP_RIGHT_RADIUS = 'border-top-right-radius';
    const BORDER_TOP_STYLE = 'border-top-style';
    const BORDER_TOP_WIDTH = 'border-top-width';
    const BORDER_WIDTH = 'border-width';
    const BOTTOM = 'bottom';
    const BOX_DECORATION_BREAK = 'box-decoration-break';
    const BOX_SHADOW = 'box-shadow';
    const BOX_SIZING = 'box-sizing';
    const BREAK_AFTER = 'break-after';
    const BREAK_BEFORE = 'break-before';
    const BREAK_INSIDE = 'break-inside';
    const CACHE = 'cache';
    const CAPTION_SIDE = 'caption-side';
    const CAPTIONS_ID = 'captions-id';
    const CAPTURE = 'capture';
    const CARET_COLOR = 'caret-color';
    const CELLPADDING = 'cellpadding';
    const CELLSPACING = 'cellspacing';
    const CHARSET = 'charset';
    const CHECKED = 'checked';
    const CHIP_STYLE = 'chip-style';
    const CIPHERTEXT = 'ciphertext';
    const CITE = 'cite';
    const CLASS_ = 'class';
    // Underscore needed because 'class' is a PHP keyword.
    const CLEAR = 'clear';
    const CLEARCOLOR = 'clearcolor';
    const CLIP = 'clip';
    const CLIPPATHUNITS = 'clippathunits';
    const CLIP_PATH = 'clip-path';
    const CLIP_RULE = 'clip-rule';
    const CLOSE_BUTTON = 'close-button';
    const COLOR = 'color';
    const COLOR_ADJUST = 'color-adjust';
    const COLOR_INTERPOLATION = 'color-interpolation';
    const COLOR_INTERPOLATION_FILTERS = 'color-interpolation-filters';
    const COLOR_PROFILE = 'color-profile';
    const COLOR_RENDERING = 'color-rendering';
    const COLS = 'cols';
    const COLSPAN = 'colspan';
    const COLUMNS = 'columns';
    const COLUMN_COUNT = 'column-count';
    const COLUMN_FILL = 'column-fill';
    const COLUMN_GAP = 'column-gap';
    const COLUMN_RULE = 'column-rule';
    const COLUMN_RULE_COLOR = 'column-rule-color';
    const COLUMN_RULE_STYLE = 'column-rule-style';
    const COLUMN_RULE_WIDTH = 'column-rule-width';
    const COLUMN_SPAN = 'column-span';
    const COLUMN_WIDTH = 'column-width';
    const CONFIG = 'config';
    const CONTENT = 'content';
    const CONTENTSCRIPTTYPE = 'contentscripttype';
    const CONTENTSTYLETYPE = 'contentstyletype';
    const CONTROLS = 'controls';
    const CONTROLSLIST = 'controlslist';
    const CONVERSIONDESTINATION = 'conversiondestination';
    const COUNT_UP = 'count-up';
    const COUNTER_INCREMENT = 'counter-increment';
    const COUNTER_RESET = 'counter-reset';
    const CREDENTIALS = 'credentials';
    const CROSSORIGIN = 'crossorigin';
    const CRYPTOKEYS = 'cryptokeys';
    const CTA_ACCENT_COLOR = 'cta-accent-color';
    const CTA_ACCENT_ELEMENT = 'cta-accent-element';
    const CTA_IMAGE = 'cta-image';
    const CTA_IMAGE_2 = 'cta-image-2';
    const CTA_TEXT = 'cta-text';
    const CURSOR = 'cursor';
    const CUSTOM_ELEMENT = 'custom-element';
    const CUSTOM_REDIRECT_DOMAIN = 'custom-redirect-domain';
    const CUSTOM_TEMPLATE = 'custom-template';
    const CUSTOM_TRACKING_ID = 'custom-tracking-id';
    const CUSTOM_VALIDATION_REPORTING = 'custom-validation-reporting';
    const CUTOFF = 'cutoff';
    const CX = 'cx';
    const CY = 'cy';
    const D = 'd';
    const DATA = 'data';
    const DATATYPE = 'datatype';
    const DATE = 'date';
    const DATES = 'dates';
    const DATETIME = 'datetime';
    const DATE_TEMPLATE = 'date-template';
    const DAY_SIZE = 'day-size';
    const DECODING = 'decoding';
    const DEEP_PARSING = 'deep-parsing';
    const DEFAULT_ = 'default';
    // Underscore needed because 'default' is a PHP keyword.
    const DEFER = 'defer';
    const DELAY = 'delay';
    const DIFFABLE = 'diffable';
    const DIFFUSECONSTANT = 'diffuseconstant';
    const DIR = 'dir';
    const DIRECTION = 'direction';
    const DISABLED = 'disabled';
    const DISABLEREMOTEPLAYBACK = 'disableremoteplayback';
    const DISABLE_DOUBLE_TAP = 'disable-double-tap';
    const DISABLE_HINT_REAPPEAR = 'disable-hint-reappear';
    const DISABLE_INLINE_WIDTH = 'disable-inline-width';
    const DISABLE_SESSION_STATES = 'disable-session-states';
    const DISPLAY = 'display';
    const DISPLAY_IN = 'display-in';
    const DIVISOR = 'divisor';
    const DOCK = 'dock';
    const DOMINANT_BASELINE = 'dominant-baseline';
    const DOTS = 'dots';
    const DOWNLOAD = 'download';
    const DRAGGABLE = 'draggable';
    const DURATION = 'duration';
    const DX = 'dx';
    const DY = 'dy';
    const EDGEMODE = 'edgemode';
    const ELEVATION = 'elevation';
    const EMPTY_CELLS = 'empty-cells';
    const ENABLEZOOM = 'enablezoom';
    const ENABLE_BACKGROUND = 'enable-background';
    const ENCRYPTED = 'encrypted';
    const ENCTYPE = 'enctype';
    const ENDPOINT = 'endpoint';
    const END_DATE = 'end-date';
    const END_INPUT_SELECTOR = 'end-input-selector';
    const ENTERKEYHINT = 'enterkeyhint';
    const ENTITY = 'entity';
    const ENTITY_LOGO_SRC = 'entity-logo-src';
    const ENTITY_URL = 'entity-url';
    const EXCLUDED_DOMAINS = 'excluded-domains';
    const EXCLUSIVE_LINKS = 'exclusive-links';
    const EXECUTE = 'execute';
    const EXPANDED = 'expanded';
    const EXPAND_SINGLE_SECTION = 'expand-single-section';
    const EXPONENT = 'exponent';
    const EXPRESSION = 'expression';
    const EXTERNALRESOURCESREQUIRED = 'externalresourcesrequired';
    const EXTRA_SPACE = 'extra-space';
    const FALLBACK = 'fallback';
    const FETCH_ERROR = 'fetch-error';
    const FETCHPRIORITY = 'fetchpriority';
    const FILL = 'fill';
    const FILL_OPACITY = 'fill-opacity';
    const FILL_RULE = 'fill-rule';
    const FILTER = 'filter';
    const FILTERRES = 'filterres';
    const FILTERUNITS = 'filterunits';
    const FILTER_EXPR = 'filter-expr';
    const FILTER_VALUE = 'filter-value';
    const FIRST = 'first';
    const FIRST_DAY_OF_WEEK = 'first-day-of-week';
    const FLEX = 'flex';
    const FLEX_BASIS = 'flex-basis';
    const FLEX_DIRECTION = 'flex-direction';
    const FLEX_FLOW = 'flex-flow';
    const FLEX_GROW = 'flex-grow';
    const FLEX_SHRINK = 'flex-shrink';
    const FLEX_WRAP = 'flex-wrap';
    const FLOAT = 'float';
    const FLOOD_COLOR = 'flood-color';
    const FLOOD_OPACITY = 'flood-opacity';
    const FOCUSABLE = 'focusable';
    const FONT = 'font';
    const FONT_FAMILY = 'font-family';
    const FONT_FEATURE_SETTINGS = 'font-feature-settings';
    const FONT_KERNING = 'font-kerning';
    const FONT_LANGUAGE_OVERRIDE = 'font-language-override';
    const FONT_SIZE = 'font-size';
    const FONT_SIZE_ADJUST = 'font-size-adjust';
    const FONT_STRETCH = 'font-stretch';
    const FONT_STYLE = 'font-style';
    const FONT_SYNTHESIS = 'font-synthesis';
    const FONT_VARIANT = 'font-variant';
    const FONT_VARIANT_ALTERNATES = 'font-variant-alternates';
    const FONT_VARIANT_CAPS = 'font-variant-caps';
    const FONT_VARIANT_EAST_ASIAN = 'font-variant-east-asian';
    const FONT_VARIANT_LIGATURES = 'font-variant-ligatures';
    const FONT_VARIANT_NUMERIC = 'font-variant-numeric';
    const FONT_VARIANT_POSITION = 'font-variant-position';
    const FONT_VARIATION_SETTINGS = 'font-variation-settings';
    const FONT_WEIGHT = 'font-weight';
    const FOOTER = 'footer';
    const FORM = 'form';
    const FORMAT = 'format';
    const FOR_ = 'for';
    // Underscore needed because 'for' is a PHP keyword.
    const FR = 'fr';
    const FRAMEBORDER = 'frameborder';
    const FROM = 'from';
    const FULLSCREEN = 'fullscreen';
    const FX = 'fx';
    const FY = 'fy';
    const G1 = 'g1';
    const G2 = 'g2';
    const GAMMA_RANGE = 'gamma-range';
    const GAP = 'gap';
    const GLYPHREF = 'glyphref';
    const GLYPH_NAME = 'glyph-name';
    const GLYPH_ORIENTATION_HORIZONTAL = 'glyph-orientation-horizontal';
    const GLYPH_ORIENTATION_VERTICAL = 'glyph-orientation-vertical';
    const GRADIENTTRANSFORM = 'gradienttransform';
    const GRADIENTUNITS = 'gradientunits';
    const GRID = 'grid';
    const GRID_AREA = 'grid-area';
    const GRID_AUTO_COLUMNS = 'grid-auto-columns';
    const GRID_AUTO_FLOW = 'grid-auto-flow';
    const GRID_AUTO_ROWS = 'grid-auto-rows';
    const GRID_COLUMN = 'grid-column';
    const GRID_COLUMN_END = 'grid-column-end';
    const GRID_COLUMN_GAP = 'grid-column-gap';
    const GRID_COLUMN_START = 'grid-column-start';
    const GRID_GAP = 'grid-gap';
    const GRID_ROW = 'grid-row';
    const GRID_ROW_END = 'grid-row-end';
    const GRID_ROW_GAP = 'grid-row-gap';
    const GRID_ROW_START = 'grid-row-start';
    const GRID_TEMPLATE = 'grid-template';
    const GRID_TEMPLATE_AREAS = 'grid-template-areas';
    const GRID_TEMPLATE_COLUMNS = 'grid-template-columns';
    const GRID_TEMPLATE_ROWS = 'grid-template-rows';
    const GTAG_ID = 'gtag-id';
    const HANGING_PUNCTUATION = 'hanging-punctuation';
    const HEADERS = 'headers';
    const HEADING_END = 'heading-end';
    const HEADING_START = 'heading-start';
    const HEIGHT = 'height';
    const HEIGHTS = 'heights';
    const HELPER_IFRAME_URL = 'helper-iframe-url';
    const HIDDEN = 'hidden';
    const HIDE_KEYBOARD_SHORTCUTS_PANEL = 'hide-keyboard-shortcuts-panel';
    const HIGH = 'high';
    const HIGHLIGHTED = 'highlighted';
    const HIGHLIGHT_USER_ENTRY = 'highlight-user-entry';
    const HORIZONTAL = 'horizontal';
    const HORIZ_ADV_X = 'horiz-adv-x';
    const HOST_SERVICE = 'host-service';
    const HREF = 'href';
    const HREFLANG = 'hreflang';
    const HSPACE = 'hspace';
    const HTML = 'html';
    const HTTP_EQUIV = 'http-equiv';
    const HYPHENS = 'hyphens';
    const ID = 'id';
    const IMAGESIZES = 'imagesizes';
    const IMAGESRCSET = 'imagesrcset';
    const IMAGE_ORIENTATION = 'image-orientation';
    const IMAGE_RENDERING = 'image-rendering';
    const IMAGE_RESOLUTION = 'image-resolution';
    const IMPLEMENTS_MEDIA_SESSION = 'implements-media-session';
    const IMPLEMENTS_ROTATE_TO_FULLSCREEN = 'implements-rotate-to-fullscreen';
    const IMPORTANCE = 'importance';
    const IMPRESSIONDATA = 'impressiondata';
    const IMPRESSIONEXPIRY = 'impressionexpiry';
    const IN = 'in';
    const IN2 = 'in2';
    const INFO_TEMPLATE = 'info-template';
    const INITIAL_SCALE = 'initial-scale';
    const INITIAL_SLIDER_POSITION = 'initial-slider-position';
    const INITIAL_X = 'initial-x';
    const INITIAL_Y = 'initial-y';
    const INLINE = 'inline';
    const INLINE_SIZE = 'inline-size';
    const INLIST = 'inlist';
    const INPUTMODE = 'inputmode';
    const INPUT_SELECTOR = 'input-selector';
    const INSET = 'inset';
    const INTEGRITY = 'integrity';
    const INTERACTIVE = 'interactive';
    const INTERCEPT = 'intercept';
    const INTERSECTION_RATIOS = 'intersection-ratios';
    const INTRINSICSIZE = 'intrinsicsize';
    const ISMAP = 'ismap';
    const ISOLATION = 'isolation';
    const ITEMID = 'itemid';
    const ITEMPROP = 'itemprop';
    const ITEMREF = 'itemref';
    const ITEMS = 'items';
    const ITEMSCOPE = 'itemscope';
    const ITEMTYPE = 'itemtype';
    const I_AMPHTML_BINDING = 'i-amphtml-binding';
    const I_AMPHTML_DISABLE_AR = 'i-amphtml-disable-ar';
    const I_AMPHTML_LAYOUT = 'i-amphtml-layout';
    const I_AMPHTML_NO_BOILERPLATE = 'i-amphtml-no-boilerplate';
    const I_AMPHTML_SSR = 'i-amphtml-ssr';
    const I_AMPHTML_VERSION = 'i-amphtml-version';
    const I_AMP_ACCESS_ID = 'i-amp-access-id';
    const JSON = 'json';
    const JUSTIFY_CONTENT = 'justify-content';
    const JUSTIFY_ITEMS = 'justify-items';
    const JUSTIFY_SELF = 'justify-self';
    const K = 'k';
    const K1 = 'k1';
    const K2 = 'k2';
    const K3 = 'k3';
    const K4 = 'k4';
    const KERNELMATRIX = 'kernelmatrix';
    const KERNELUNITLENGTH = 'kernelunitlength';
    const KERNING = 'kerning';
    const KEY = 'key';
    const KEYBOARD_SELECT_MODE = 'keyboard-select-mode';
    const KIND = 'kind';
    const LABEL = 'label';
    const LANG = 'lang';
    const LAYOUT = 'layout';
    const LEFT = 'left';
    const LENGTHADJUST = 'lengthadjust';
    const LETTER_SPACING = 'letter-spacing';
    const LIGHTBOX = 'lightbox';
    const LIGHTBOX_EXCLUDE = 'lightbox-exclude';
    const LIGHTBOX_THUMBNAIL_ID = 'lightbox-thumbnail-id';
    const LIGHTING_COLOR = 'lighting-color';
    const LIMITINGCONEANGLE = 'limitingconeangle';
    const LINE_BREAK = 'line-break';
    const LINE_HEIGHT = 'line-height';
    const LINKMATE = 'linkmate';
    const LINK_ATTRIBUTE = 'link-attribute';
    const LINK_SELECTOR = 'link-selector';
    const LIST_ = 'list';
    // Underscore needed because 'list' is a PHP keyword.
    const LIST_STYLE = 'list-style';
    const LIST_STYLE_IMAGE = 'list-style-image';
    const LIST_STYLE_POSITION = 'list-style-position';
    const LIST_STYLE_TYPE = 'list-style-type';
    const LIVE_STORY = 'live-story';
    const LIVE_STORY_DISABLED = 'live-story-disabled';
    const LOADING = 'loading';
    const LOAD_MORE = 'load-more';
    const LOAD_MORE_BOOKMARK = 'load-more-bookmark';
    const LOAD_MORE_BUTTON = 'load-more-button';
    const LOAD_MORE_CLICKABLE = 'load-more-clickable';
    const LOAD_MORE_END = 'load-more-end';
    const LOAD_MORE_FAILED = 'load-more-failed';
    const LOAD_MORE_LOADING = 'load-more-loading';
    const LOCALE = 'locale';
    const LOCK_BOUNDS = 'lock-bounds';
    const LONGDESC = 'longdesc';
    const LOOP = 'loop';
    const LOW = 'low';
    const MARGIN = 'margin';
    const MARGIN_BOTTOM = 'margin-bottom';
    const MARGIN_LEFT = 'margin-left';
    const MARGIN_RIGHT = 'margin-right';
    const MARGIN_TOP = 'margin-top';
    const MARKER = 'marker';
    const MARKERHEIGHT = 'markerheight';
    const MARKERUNITS = 'markerunits';
    const MARKERWIDTH = 'markerwidth';
    const MARKER_END = 'marker-end';
    const MARKER_MID = 'marker-mid';
    const MARKER_START = 'marker-start';
    const MASK = 'mask';
    const MASKCONTENTUNITS = 'maskcontentunits';
    const MASKUNITS = 'maskunits';
    const MASK_OUTPUT = 'mask-output';
    const MASK_TRIM_ZEROS = 'mask-trim-zeros';
    const MAX = 'max';
    const MAXIMUM_NIGHTS = 'maximum-nights';
    const MAXLENGTH = 'maxlength';
    const MAXPIXELRATIO = 'maxpixelratio';
    const MAX_AGE = 'max-age';
    const MAX_ENTRIES = 'max-entries';
    const MAX_FONT_SIZE = 'max-font-size';
    const MAX_HEIGHT = 'max-height';
    const MAX_ITEM_WIDTH = 'max-item-width';
    const MAX_ITEMS = 'max-items';
    const MAX_PAGES = 'max-pages';
    const MAX_SCALE = 'max-scale';
    const MAX_VISIBLE_COUNT = 'max-visible-count';
    const MAX_WIDTH = 'max-width';
    const MEDIA = 'media';
    const METHOD = 'method';
    const MIN = 'min';
    const MINIMUM_NIGHTS = 'minimum-nights';
    const MINLENGTH = 'minlength';
    const MIN_CHARACTERS = 'min-characters';
    const MIN_FONT_SIZE = 'min-font-size';
    const MIN_HEIGHT = 'min-height';
    const MIN_ITEM_WIDTH = 'min-item-width';
    const MIN_VISIBLE_COUNT = 'min-visible-count';
    const MIN_WIDTH = 'min-width';
    const MIXED_LENGTH = 'mixed-length';
    const MIX_BLEND_MODE = 'mix-blend-mode';
    const MODE = 'mode';
    const MONTH_FORMAT = 'month-format';
    const MULTIPLE = 'multiple';
    const MUTED = 'muted';
    const NAME = 'name';
    const NEXT_PAGE_HIDE = 'next-page-hide';
    const NEXT_PAGE_NO_AD = 'next-page-no-ad';
    const NEXT_PAGE_REPLACE = 'next-page-replace';
    const NOAUDIO = 'noaudio';
    const NOAUTOPLAY = 'noautoplay';
    const NODOM = 'nodom';
    const NOLOADING = 'noloading';
    const NOMODULE = 'nomodule';
    const NONCE = 'nonce';
    const NOVALIDATE = 'novalidate';
    const NO_FALLBACK = 'no-fallback';
    const NO_VERIFY = 'no-verify';
    const NRTV_ACCOUNT_NAME = 'nrtv-account-name';
    const NUMBER_OF_MONTHS = 'number-of-months';
    const NUMOCTAVES = 'numoctaves';
    const OBJECT_FIT = 'object-fit';
    const OBJECT_POSITION = 'object-position';
    const OFFSET = 'offset';
    const OFFSET_DISTANCE = 'offset-distance';
    const OFFSET_SECONDS = 'offset-seconds';
    const ON = 'on';
    const ONCE = 'once';
    const ON_ERROR_ADD_CLASS = 'on-error-add-class';
    const ON_ERROR_REMOVE_CLASS = 'on-error-remove-class';
    const ON_LOAD_ADD_CLASS = 'on-load-add-class';
    const ON_LOAD_REMOVE_CLASS = 'on-load-remove-class';
    const OPACITY = 'opacity';
    const OPEN = 'open';
    const OPEN_AFTER_CLEAR = 'open-after-clear';
    const OPEN_AFTER_SELECT = 'open-after-select';
    const OPEN_BUTTON = 'open-button';
    const OPERATOR = 'operator';
    const OPTIMUM = 'optimum';
    const OPTION = 'option';
    const OPTION_1_CONFETTI = 'option-1-confetti';
    const OPTION_1_CORRECT = 'option-1-correct';
    const OPTION_1_IMAGE = 'option-1-image';
    const OPTION_1_IMAGE_ALT = 'option-1-image-alt';
    const OPTION_1_RESULTS_CATEGORY = 'option-1-results-category';
    const OPTION_1_RESULTS_THRESHOLD = 'option-1-results-threshold';
    const OPTION_1_TEXT = 'option-1-text';
    const OPTION_2_CONFETTI = 'option-2-confetti';
    const OPTION_2_CORRECT = 'option-2-correct';
    const OPTION_2_IMAGE = 'option-2-image';
    const OPTION_2_IMAGE_ALT = 'option-2-image-alt';
    const OPTION_2_RESULTS_CATEGORY = 'option-2-results-category';
    const OPTION_2_RESULTS_THRESHOLD = 'option-2-results-threshold';
    const OPTION_2_TEXT = 'option-2-text';
    const OPTION_3_CONFETTI = 'option-3-confetti';
    const OPTION_3_CORRECT = 'option-3-correct';
    const OPTION_3_IMAGE = 'option-3-image';
    const OPTION_3_IMAGE_ALT = 'option-3-image-alt';
    const OPTION_3_RESULTS_CATEGORY = 'option-3-results-category';
    const OPTION_3_RESULTS_THRESHOLD = 'option-3-results-threshold';
    const OPTION_3_TEXT = 'option-3-text';
    const OPTION_4_CONFETTI = 'option-4-confetti';
    const OPTION_4_CORRECT = 'option-4-correct';
    const OPTION_4_IMAGE = 'option-4-image';
    const OPTION_4_IMAGE_ALT = 'option-4-image-alt';
    const OPTION_4_RESULTS_CATEGORY = 'option-4-results-category';
    const OPTION_4_RESULTS_THRESHOLD = 'option-4-results-threshold';
    const OPTION_4_TEXT = 'option-4-text';
    const ORDER = 'order';
    const ORIENT = 'orient';
    const ORIENTATION = 'orientation';
    const ORPHANS = 'orphans';
    const OUTLINE = 'outline';
    const OUTLINE_COLOR = 'outline-color';
    const OUTLINE_OFFSET = 'outline-offset';
    const OUTLINE_STYLE = 'outline-style';
    const OUTLINE_WIDTH = 'outline-width';
    const OUTSET_ARROWS = 'outset-arrows';
    const OVERFLOW = 'overflow';
    const OVERFLOW_STYLE = 'overflow-style';
    const OVERFLOW_WRAP = 'overflow-wrap';
    const OVERFLOW_X = 'overflow-x';
    const OVERFLOW_Y = 'overflow-y';
    const OVERRIDABLE = 'overridable';
    const PADDING = 'padding';
    const PADDING_BOTTOM = 'padding-bottom';
    const PADDING_LEFT = 'padding-left';
    const PADDING_RIGHT = 'padding-right';
    const PADDING_TOP = 'padding-top';
    const PAGE_BREAK_AFTER = 'page-break-after';
    const PAGE_BREAK_BEFORE = 'page-break-before';
    const PAGE_BREAK_INSIDE = 'page-break-inside';
    const PAGINATION = 'pagination';
    const PATHLENGTH = 'pathlength';
    const PATTERN = 'pattern';
    const PATTERNCONTENTUNITS = 'patterncontentunits';
    const PATTERNTRANSFORM = 'patterntransform';
    const PATTERNUNITS = 'patternunits';
    const PAUSE = 'pause';
    const PAUSE_AFTER = 'pause-after';
    const PAUSE_BEFORE = 'pause-before';
    const PEEK = 'peek';
    const PERMISSION_DIALOG_URL = 'permission-dialog-url';
    const PERSPECTIVE = 'perspective';
    const PERSPECTIVE_ORIGIN = 'perspective-origin';
    const PITCH = 'pitch';
    const PITCH_END = 'pitch-end';
    const PITCH_RANGE = 'pitch-range';
    const PITCH_START = 'pitch-start';
    const PLACEHOLDER = 'placeholder';
    const PLACE_ITEMS = 'place-items';
    const PLAYSINLINE = 'playsinline';
    const POINTER_EVENTS = 'pointer-events';
    const POINTS = 'points';
    const POINTSATX = 'pointsatx';
    const POINTSATY = 'pointsaty';
    const POINTSATZ = 'pointsatz';
    const POOOL_ACCESS_CONTENT = 'poool-access-content';
    const POOOL_ACCESS_PREVIEW = 'poool-access-preview';
    const POSITION = 'position';
    const POSTER = 'poster';
    const POSTER_LANDSCAPE_SRC = 'poster-landscape-src';
    const POSTER_PORTRAIT_SRC = 'poster-portrait-src';
    const POSTER_SQUARE_SRC = 'poster-square-src';
    const PREFETCH = 'prefetch';
    const PREFIX = 'prefix';
    const PRELOAD = 'preload';
    const PRESERVEALPHA = 'preservealpha';
    const PRESERVEASPECTRATIO = 'preserveaspectratio';
    const PRESET = 'preset';
    const PRIMITIVEUNITS = 'primitiveunits';
    const PROFILE = 'profile';
    const PROMPT_SIZE = 'prompt-size';
    const PROMPT_TEXT = 'prompt-text';
    const PROPERTY = 'property';
    const PUBDATE = 'pubdate';
    const PUBLISHER = 'publisher';
    const PUBLISHER_CODE = 'publisher-code';
    const PUBLISHER_LOGO_SRC = 'publisher-logo-src';
    const QUERY = 'query';
    const QUOTES = 'quotes';
    const R = 'r';
    const RADIUS = 'radius';
    const READONLY = 'readonly';
    const RECOMMENDATION_BOX = 'recommendation-box';
    const REFERRERPOLICY = 'referrerpolicy';
    const REFX = 'refx';
    const REFY = 'refy';
    const REL = 'rel';
    const RENDERER = 'renderer';
    const REPORTINGORIGIN = 'reportingorigin';
    const REQUIRED = 'required';
    const REQUIREDEXTENSIONS = 'requiredextensions';
    const REQUIREDFEATURES = 'requiredfeatures';
    const RESET_ON_REFRESH = 'reset-on-refresh';
    const RESET_ON_RESIZE = 'reset-on-resize';
    const RESIZABLE = 'resizable';
    const RESIZE = 'resize';
    const RESOURCE = 'resource';
    const RESULT = 'result';
    const REV = 'rev';
    const REVERSED = 'reversed';
    const RICHNESS = 'richness';
    const RIGHT = 'right';
    const ROLE = 'role';
    const ROTATE = 'rotate';
    const ROTATE_TO_FULLSCREEN = 'rotate-to-fullscreen';
    const ROWS = 'rows';
    const ROWSPAN = 'rowspan';
    const ROW_GAP = 'row-gap';
    const RTC_CONFIG = 'rtc-config';
    const RX = 'rx';
    const RY = 'ry';
    const SANDBOX = 'sandbox';
    const SANDBOXED = 'sandboxed';
    const SCALE = 'scale';
    const SCALE_END = 'scale-end';
    const SCALE_START = 'scale-start';
    const SCENE_HEADING = 'scene-heading';
    const SCENE_PITCH = 'scene-pitch';
    const SCENE_ROLL = 'scene-roll';
    const SCHEME = 'scheme';
    const SCOPE = 'scope';
    const SCRIPT = 'script';
    const SCROLLABLE = 'scrollable';
    const SCROLLING = 'scrolling';
    const SECOND = 'second';
    const SEED = 'seed';
    const SELECTED = 'selected';
    const SELECTIONDIRECTION = 'selectiondirection';
    const SELECTIONEND = 'selectionend';
    const SELECTIONSTART = 'selectionstart';
    const SEPARATOR = 'separator';
    const SERVICE_WORKER_SCOPE = 'service-worker-scope';
    const SERVICE_WORKER_URL = 'service-worker-url';
    const SHAPE_RENDERING = 'shape-rendering';
    const SHA_256_HASH = 'sha-256-hash';
    const SHOW_TOOLTIP = 'show-tooltip';
    const SIDE = 'side';
    const SINGLE_ITEM = 'single-item';
    const SIZE = 'size';
    const SIZES = 'sizes';
    const SKETCH_TYPE = 'sketch-type';
    const SLIDE = 'slide';
    const SLIDE_ALIGN = 'slide-align';
    const SLOPE = 'slope';
    const SLOT = 'slot';
    const SMOOTHING = 'smoothing';
    const SNAP = 'snap';
    const SNAP_ALIGN = 'snap-align';
    const SNAP_BY = 'snap-by';
    const SOLID_COLOR = 'solid-color';
    const SOLID_OPACITY = 'solid-opacity';
    const SORT = 'sort';
    const SORTABLE = 'sortable';
    const SORTED = 'sorted';
    const SPACING = 'spacing';
    const SPAN = 'span';
    const SPEAK = 'speak';
    const SPEAK_HEADER = 'speak-header';
    const SPEAK_NUMERAL = 'speak-numeral';
    const SPEAK_PUNCTUATION = 'speak-punctuation';
    const SPECULARCONSTANT = 'specularconstant';
    const SPECULAREXPONENT = 'specularexponent';
    const SPEECH_RATE = 'speech-rate';
    const SPELLCHECK = 'spellcheck';
    const SPREADMETHOD = 'spreadmethod';
    const SRC = 'src';
    const SRCDOC = 'srcdoc';
    const SRCLANG = 'srclang';
    const SRCSET = 'srcset';
    const STANDALONE = 'standalone';
    const START = 'start';
    const STARTOFFSET = 'startoffset';
    const START_DATE = 'start-date';
    const START_INPUT_SELECTOR = 'start-input-selector';
    const STDDEVIATION = 'stddeviation';
    const STEP = 'step';
    const STEP_SIZE = 'step-size';
    const STICKY = 'sticky';
    const STITCHTILES = 'stitchtiles';
    const STOP_COLOR = 'stop-color';
    const STOP_OPACITY = 'stop-opacity';
    const STRESS = 'stress';
    const STROKE = 'stroke';
    const STROKE_DASHARRAY = 'stroke-dasharray';
    const STROKE_DASHOFFSET = 'stroke-dashoffset';
    const STROKE_LINECAP = 'stroke-linecap';
    const STROKE_LINEJOIN = 'stroke-linejoin';
    const STROKE_MITERLIMIT = 'stroke-miterlimit';
    const STROKE_OPACITY = 'stroke-opacity';
    const STROKE_WIDTH = 'stroke-width';
    const STYLE = 'style';
    const SUBMITTING = 'submitting';
    const SUBMIT_ERROR = 'submit-error';
    const SUBMIT_ON_ENTER = 'submit-on-enter';
    const SUBMIT_SUCCESS = 'submit-success';
    const SUBSCRIPTIONS_ACTION = 'subscriptions-action';
    const SUBSCRIPTIONS_ACTIONS = 'subscriptions-actions';
    const SUBSCRIPTIONS_DECORATE = 'subscriptions-decorate';
    const SUBSCRIPTIONS_DIALOG = 'subscriptions-dialog';
    const SUBSCRIPTIONS_DISPLAY = 'subscriptions-display';
    const SUBSCRIPTIONS_GOOGLE_RTC = 'subscriptions-google-rtc';
    const SUBSCRIPTIONS_LANG = 'subscriptions-lang';
    const SUBSCRIPTIONS_SECTION = 'subscriptions-section';
    const SUBSCRIPTIONS_SERVICE = 'subscriptions-service';
    const SUGGEST_FIRST = 'suggest-first';
    const SUPPORTS_LANDSCAPE = 'supports-landscape';
    const SURFACESCALE = 'surfacescale';
    const SWG_AMP_CACHE_NONCE = 'swg-amp-cache-nonce';
    const SYSTEMLANGUAGE = 'systemlanguage';
    const TABINDEX = 'tabindex';
    const TABLE = 'table';
    const TABLEVALUES = 'tablevalues';
    const TABLE_LAYOUT = 'table-layout';
    const TAB_SIZE = 'tab-size';
    const TARGET = 'target';
    const TARGETX = 'targetx';
    const TARGETY = 'targety';
    const TEMPLATE = 'template';
    const TEXTLENGTH = 'textlength';
    const TEXT_ALIGN = 'text-align';
    const TEXT_ALIGN_LAST = 'text-align-last';
    const TEXT_ANCHOR = 'text-anchor';
    const TEXT_COMBINE_UPRIGHT = 'text-combine-upright';
    const TEXT_DECORATION = 'text-decoration';
    const TEXT_DECORATION_COLOR = 'text-decoration-color';
    const TEXT_DECORATION_LINE = 'text-decoration-line';
    const TEXT_DECORATION_SKIP = 'text-decoration-skip';
    const TEXT_DECORATION_SKIP_INK = 'text-decoration-skip-ink';
    const TEXT_DECORATION_STYLE = 'text-decoration-style';
    const TEXT_EMPHASIS = 'text-emphasis';
    const TEXT_EMPHASIS_COLOR = 'text-emphasis-color';
    const TEXT_EMPHASIS_POSITION = 'text-emphasis-position';
    const TEXT_EMPHASIS_STYLE = 'text-emphasis-style';
    const TEXT_FILL_COLOR = 'text-fill-color';
    const TEXT_INDENT = 'text-indent';
    const TEXT_JUSTIFY = 'text-justify';
    const TEXT_ORIENTATION = 'text-orientation';
    const TEXT_OVERFLOW = 'text-overflow';
    const TEXT_RENDERING = 'text-rendering';
    const TEXT_SHADOW = 'text-shadow';
    const TEXT_STROKE = 'text-stroke';
    const TEXT_STROKE_COLOR = 'text-stroke-color';
    const TEXT_STROKE_WIDTH = 'text-stroke-width';
    const TEXT_TRANSFORM = 'text-transform';
    const TEXT_UNDERLINE_POSITION = 'text-underline-position';
    const THEME = 'theme';
    const TIMELEFT_MS = 'timeleft-ms';
    const TIMELINE_EVENT_PREFIX = 'timeline-event-prefix';
    const TIMEOUT = 'timeout';
    const TIMESTAMP_MS = 'timestamp-ms';
    const TIMESTAMP_SECONDS = 'timestamp-seconds';
    const TITLE = 'title';
    const TOOLBAR = 'toolbar';
    const TOOLBAR_TARGET = 'toolbar-target';
    const TOP = 'top';
    const TOUCH_KEYBOARD_EDITABLE = 'touch-keyboard-editable';
    const TRACKING = 'tracking';
    const TRANSFORM = 'transform';
    const TRANSFORMED = 'transformed';
    const TRANSFORM_BOX = 'transform-box';
    const TRANSFORM_ORIGIN = 'transform-origin';
    const TRANSFORM_STYLE = 'transform-style';
    const TRANSITION = 'transition';
    const TRANSITION_DELAY = 'transition-delay';
    const TRANSITION_DURATION = 'transition-duration';
    const TRANSITION_PROPERTY = 'transition-property';
    const TRANSITION_TIMING_FUNCTION = 'transition-timing-function';
    const TRANSLATE = 'translate';
    const TRANSLATE_X = 'translate-x';
    const TRANSLATE_Y = 'translate-y';
    const TRIGGER = 'trigger';
    const TYPE = 'type';
    const TYPEOF = 'typeof';
    const U1 = 'u1';
    const U2 = 'u2';
    const UNICODE = 'unicode';
    const UNICODE_BIDI = 'unicode-bidi';
    const UPDATE = 'update';
    const USEMAP = 'usemap';
    const USER_SELECT = 'user-select';
    const VALIDATION_FOR = 'validation-for';
    const VALIGN = 'valign';
    const VALUE = 'value';
    const VALUES = 'values';
    const VECTOR_EFFECT = 'vector-effect';
    const VERIFY_ERROR = 'verify-error';
    const VERIFY_XHR = 'verify-xhr';
    const VERSION = 'version';
    const VERTICAL_ALIGN = 'vertical-align';
    const VERT_ADV_Y = 'vert-adv-y';
    const VERT_ORIGIN_X = 'vert-origin-x';
    const VERT_ORIGIN_Y = 'vert-origin-y';
    const VIEWBOX = 'viewbox';
    const VIEWPORT = 'viewport';
    const VIEWPORT_MARGINS = 'viewport-margins';
    const VIEWTARGET = 'viewtarget';
    const VISIBILITY = 'visibility';
    const VISIBLE_COUNT = 'visible-count';
    const VISIBLE_WHEN_INVALID = 'visible-when-invalid';
    const VOCAB = 'vocab';
    const VOICE_FAMILY = 'voice-family';
    const VOLUME = 'volume';
    const VSPACE = 'vspace';
    const WEEK_DAY_FORMAT = 'week-day-format';
    const WHEN_ENDED = 'when-ended';
    const WHITE_SPACE = 'white-space';
    const WIDOWS = 'widows';
    const WIDTH = 'width';
    const WORD_BREAK = 'word-break';
    const WORD_SPACING = 'word-spacing';
    const WORD_WRAP = 'word-wrap';
    const WRAP = 'wrap';
    const WRITING_MODE = 'writing-mode';
    const X = 'x';
    const X1 = 'x1';
    const X2 = 'x2';
    const XCHANNELSELECTOR = 'xchannelselector';
    const XLINK_ACTUATE = 'xlink-actuate';
    const XLINK_ARCROLE = 'xlink-arcrole';
    const XLINK_HREF = 'xlink-href';
    const XLINK_ROLE = 'xlink-role';
    const XLINK_SHOW = 'xlink-show';
    const XLINK_TITLE = 'xlink-title';
    const XLINK_TYPE = 'xlink-type';
    const XMLNS = 'xmlns';
    const XMLNS_XLINK = 'xmlns-xlink';
    const XML_LANG = 'xml-lang';
    const XML_SPACE = 'xml-space';
    const XSSI_PREFIX = 'xssi-prefix';
    const Y = 'y';
    const Y1 = 'y1';
    const Y2 = 'y2';
    const YCHANNELSELECTOR = 'ychannelselector';
    const ZOOMANDPAN = 'zoomandpan';
    const ZOOM_END = 'zoom-end';
    const ZOOM_START = 'zoom-start';
    const Z_INDEX = 'z-index';
    const _MOZ_APPEARANCE = '-moz-appearance';
    const _WEBKIT_APPEARANCE = '-webkit-appearance';
    const _WEBKIT_TAP_HIGHLIGHT_COLOR = '-webkit-tap-highlight-color';
    const Z = 'z';
    const ALL_AMP = [self::AMP, self::AMP_EMOJI, self::AMP_EMOJI_ALT];
    const ALL_AMP4ADS = [self::AMP4ADS, self::AMP4ADS_EMOJI, self::AMP4ADS_EMOJI_ALT];
    const ALL_AMP4EMAIL = [self::AMP4EMAIL, self::AMP4EMAIL_EMOJI, self::AMP4EMAIL_EMOJI_ALT];
    const ALL_BOILERPLATES = [self::AMP_BOILERPLATE, self::AMP4ADS_BOILERPLATE, self::AMP4EMAIL_BOILERPLATE];
    const TYPE_HTML = 'text/html';
    const TYPE_JSON = 'application/json';
    const TYPE_LD_JSON = 'application/ld+json';
    const TYPE_PDF = 'application/pdf';
    const TYPE_MODULE = 'module';
    const TYPE_TEXT_PLAIN = 'text/plain';
    const REL_AMPHTML = 'amphtml';
    const REL_CANONICAL = 'canonical';
    const REL_DNS_PREFETCH = 'dns-prefetch';
    const REL_ICON = 'icon';
    const REL_MODULEPRELOAD = 'modulepreload';
    const REL_NOAMPHTML = 'noamphtml';
    const REL_NOFOLLOW = 'nofollow';
    const REL_PRECONNECT = 'preconnect';
    const REL_PREFETCH = 'prefetch';
    const REL_PRELOAD = 'preload';
    const REL_PRERENDER = 'prerender';
    const REL_STYLESHEET = 'stylesheet';
    const DATA_ACCOUNT = 'data-account';
    const DATA_ACTION = 'data-action';
    const DATA_AD_TAG_URL = 'data-ad-tag-url';
    const DATA_AMPDEVMODE = 'data-ampdevmode';
    const DATA_AMP_AUTOCOMPLETE_OPT_IN = 'data-amp-autocomplete-opt-in';
    const DATA_AMP_BIND_SRC = 'data-amp-bind-src';
    const DATA_AMP_STORY_PLAYER_POSTER_IMG = 'data-amp-story-player-poster-img';
    const DATA_APESTER_CHANNEL_TOKEN = 'data-apester-channel-token';
    const DATA_APESTER_MEDIA_ID = 'data-apester-media-id';
    const DATA_API_KEY = 'data-api-key';
    const DATA_APP_KEY = 'data-app-key';
    const DATA_BCID = 'data-bcid';
    const DATA_BORDER = 'data-border';
    const DATA_CALL_TO_ACTION_LABEL = 'data-call-to-action-label';
    const DATA_CARDS = 'data-cards';
    const DATA_CAROUSEL = 'data-carousel';
    const DATA_CLIENT = 'data-client';
    const DATA_COLOR = 'data-color';
    const DATA_COMMENTS = 'data-comments';
    const DATA_CONTENT = 'data-content';
    const DATA_CONTENT_ID = 'data-content-id';
    const DATA_CONTENT_TYPE = 'data-content-type';
    const DATA_CONVERSATION = 'data-conversation';
    const DATA_COUNT_UP = 'data-count-up';
    const DATA_CSS_STRICT = 'data-css-strict';
    const DATA_DISMISS_HREF = 'data-dismiss-href';
    const DATA_DO = 'data-do';
    const DATA_DOMAIN = 'data-domain';
    const DATA_DYNAMIC = 'data-dynamic';
    const DATA_EID = 'data-eid';
    const DATA_EMBEDCODE = 'data-embedcode';
    const DATA_EMBEDLIVE = 'data-embedlive';
    const DATA_EMBEDPARENT = 'data-embedparent';
    const DATA_EMBEDTYPE = 'data-embedtype';
    const DATA_EMBED_ID = 'data-embed-id';
    const DATA_ENABLE_REFRESH = 'data-enable-refresh';
    const DATA_ENDSCREEN_ENABLE = 'data-endscreen-enable';
    const DATA_EPISODE = 'data-episode';
    const DATA_EPISODES = 'data-episodes';
    const DATA_EXIT_MODE = 'data-exit-mode';
    const DATA_FORMULA = 'data-formula';
    const DATA_GFYID = 'data-gfyid';
    const DATA_GISTID = 'data-gistid';
    const DATA_HERO = 'data-hero';
    const DATA_HERO_CANDIDATE = 'data-hero-candidate';
    const DATA_HREF = 'data-href';
    const DATA_ID = 'data-id';
    const DATA_IFRAME_SRC = 'data-iframe-src';
    const DATA_IMG = 'data-img';
    const DATA_IMGUR_ID = 'data-imgur-id';
    const DATA_INFO = 'data-info';
    const DATA_INTRO = 'data-intro';
    const DATA_ITEM = 'data-item';
    const DATA_ITEMS = 'data-items';
    const DATA_ITEM_INFO = 'data-item-info';
    const DATA_KEY = 'data-key';
    const DATA_LABEL = 'data-label';
    const DATA_LIGHT = 'data-light';
    const DATA_LIMIT = 'data-limit';
    const DATA_LIVE_CHANNELID = 'data-live-channelid';
    const DATA_LOCALE = 'data-locale';
    const DATA_MAX_ITEMS_PER_PAGE = 'data-max-items-per-page';
    const DATA_MEDIAID = 'data-mediaid';
    const DATA_MEDIA_HASHED_ID = 'data-media-hashed-id';
    const DATA_MEDIA_ID = 'data-media-id';
    const DATA_MINIMUM_DATE_FACTOR = 'data-minimum-date-factor';
    const DATA_MODE = 'data-mode';
    const DATA_MOMENTID = 'data-momentid';
    const DATA_MULTI_SIZE = 'data-multi-size';
    const DATA_MUTE = 'data-mute';
    const DATA_MY_CONTENT = 'data-my-content';
    const DATA_NAME = 'data-name';
    const DATA_ORIGIN = 'data-origin';
    const DATA_OUTRO = 'data-outro';
    const DATA_OUTSTREAM = 'data-outstream';
    const DATA_PARAM_VIDEOID = 'data-param-videoid';
    const DATA_PARTNER = 'data-partner';
    const DATA_PCODE = 'data-pcode';
    const DATA_PID = 'data-pid';
    const DATA_PLAYER = 'data-player';
    const DATA_PLAYERID = 'data-playerid';
    const DATA_PLAYER_ID = 'data-player-id';
    const DATA_PLAYLIST = 'data-playlist';
    const DATA_PLAYLISTID = 'data-playlistid';
    const DATA_PLAYLIST_ID = 'data-playlist-id';
    const DATA_POLL_INTERVAL = 'data-poll-interval';
    const DATA_PRODUCT_CODE = 'data-product-code';
    const DATA_PROFILEID = 'data-profileid';
    const DATA_PUB_ID = 'data-pub-id';
    const DATA_RIDDLE_ID = 'data-riddle-id';
    const DATA_SCANNED_ELEMENT = 'data-scanned-element';
    const DATA_SCANNED_ELEMENT_TYPE = 'data-scanned-element-type';
    const DATA_SCOPED_KEYWORDS = 'data-scoped-keywords';
    const DATA_SECRET_TOKEN = 'data-secret-token';
    const DATA_SHARE_BUTTONS = 'data-share-buttons';
    const DATA_SHARE_ENDPOINT = 'data-share-endpoint';
    const DATA_SHARE_MEDIA = 'data-share-media';
    const DATA_SHARE_URL = 'data-share-url';
    const DATA_SHARING = 'data-sharing';
    const DATA_SHARING_ENABLE = 'data-sharing-enable';
    const DATA_SHORTCODE = 'data-shortcode';
    const DATA_SHOW_IF_HREF = 'data-show-if-href';
    const DATA_SITEKEY = 'data-sitekey';
    const DATA_SITE_ID = 'data-site-id';
    const DATA_SLOT = 'data-slot';
    const DATA_SORT_TIME = 'data-sort-time';
    const DATA_SPEAKABLE = 'data-speakable';
    const DATA_SRC = 'data-src';
    const DATA_START = 'data-start';
    const DATA_STORY_SUPPORTS_LANDSCAPE = 'data-story-supports-landscape';
    const DATA_STREAMTYPE = 'data-streamtype';
    const DATA_TAG = 'data-tag';
    const DATA_TAGS = 'data-tags';
    const DATA_TERMS = 'data-terms';
    const DATA_TILE = 'data-tile';
    const DATA_TIMELINE_ID = 'data-timeline-id';
    const DATA_TIMELINE_OWNER_SCREEN_NAME = 'data-timeline-owner-screen-name';
    const DATA_TIMELINE_SCREEN_NAME = 'data-timeline-screen-name';
    const DATA_TIMELINE_SLUG = 'data-timeline-slug';
    const DATA_TIMELINE_SOURCE_TYPE = 'data-timeline-source-type';
    const DATA_TIMELINE_URL = 'data-timeline-url';
    const DATA_TIMELINE_USER_ID = 'data-timeline-user-id';
    const DATA_TOMBSTONE = 'data-tombstone';
    const DATA_TOOLTIP_ICON = 'data-tooltip-icon';
    const DATA_TRACKID = 'data-trackid';
    const DATA_TRACKING_IDS = 'data-tracking-ids';
    const DATA_TWEETID = 'data-tweetid';
    const DATA_UI_HIGHLIGHT = 'data-ui-highlight';
    const DATA_UI_LOGO = 'data-ui-logo';
    const DATA_UPDATE_TIME = 'data-update-time';
    const DATA_URL = 'data-url';
    const DATA_VIDEO = 'data-video';
    const DATA_VIDEOID = 'data-videoid';
    const DATA_VINEID = 'data-vineid';
    const DATA_VISUAL = 'data-visual';
    const DATA_VOICE = 'data-voice';
    const DATA_WEBCARE_ID = 'data-webcare-id';
    const DATA_WIDGET_ID = 'data-widget-id';
    const DATA_WIDGET_TYPE = 'data-widget-type';
    const DATA_X = 'data-x';
    const DATA_Y = 'data-y';
    const DATA_ZOOM = 'data-zoom';
    const CROSSORIGIN_ANONYMOUS = 'anonymous';
    const CROSSORIGIN_USE_CREDENTIALS = 'use-credentials';
}
