// @ts-ignore
import React from 'react';
import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const cloudUpload: React.FC<CustomIconProps> = ({
    size = 24,
    fill = 'none',
    stroke = 'none',
    strokeWidth = 1,
    viewBox = '0 0 24 24',
    ...props
}) => (
    <svg
        width={size}
        height={size}
        viewBox={viewBox}
        fill={fill}
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path d="M11 12.85L10.1 13.725C9.91667 13.9083 9.6875 14 9.4125 14C9.1375 14 8.9 13.9 8.7 13.7C8.51667 13.5167 8.425 13.2833 8.425 13C8.425 12.7167 8.51667 12.4833 8.7 12.3L11.3 9.7C11.5 9.5 11.7333 9.4 12 9.4C12.2667 9.4 12.5 9.5 12.7 9.7L15.3 12.3C15.4833 12.4833 15.5792 12.7125 15.5875 12.9875C15.5958 13.2625 15.5 13.5 15.3 13.7C15.1167 13.8833 14.8875 13.9792 14.6125 13.9875C14.3375 13.9958 14.1 13.9083 13.9 13.725L13 12.85V18H18.5C19.2 18 19.7917 17.7583 20.275 17.275C20.7583 16.7917 21 16.2 21 15.5C21 14.8 20.7583 14.2083 20.275 13.725C19.7917 13.2417 19.2 13 18.5 13H17V11C17 9.61667 16.5125 8.4375 15.5375 7.4625C14.5625 6.4875 13.3833 6 12 6C10.6167 6 9.4375 6.4875 8.4625 7.4625C7.4875 8.4375 7 9.61667 7 11H6.5C5.53333 11 4.70833 11.3417 4.025 12.025C3.34167 12.7083 3 13.5333 3 14.5C3 15.4667 3.34167 16.2917 4.025 16.975C4.70833 17.6583 5.53333 18 6.5 18H8C8.28333 18 8.52083 18.0958 8.7125 18.2875C8.90417 18.4792 9 18.7167 9 19C9 19.2833 8.90417 19.5208 8.7125 19.7125C8.52083 19.9042 8.28333 20 8 20H6.5C4.98333 20 3.6875 19.475 2.6125 18.425C1.5375 17.375 1 16.0917 1 14.575C1 13.275 1.39167 12.1167 2.175 11.1C2.95833 10.0833 3.98333 9.43333 5.25 9.15C5.66667 7.61667 6.5 6.375 7.75 5.425C9 4.475 10.4167 4 12 4C13.95 4 15.6042 4.67917 16.9625 6.0375C18.3208 7.39583 19 9.05 19 11C20.15 11.1333 21.1042 11.6292 21.8625 12.4875C22.6208 13.3458 23 14.35 23 15.5C23 16.75 22.5625 17.8125 21.6875 18.6875C20.8125 19.5625 19.75 20 18.5 20H13C12.45 20 11.9792 19.8042 11.5875 19.4125C11.1958 19.0208 11 18.55 11 18V12.85Z" />
    </svg>
);

export default cloudUpload;